/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.threerings.openal.StreamDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;

public class Mp3StreamDecoder
extends StreamDecoder {
    protected Bitstream _istream;
    protected Header _header;
    protected Decoder _decoder;
    protected SampleBuffer _buffer;
    protected int _offset;

    @Override
    public void init(InputStream in) throws IOException {
        this._istream = new Bitstream(in);
        try {
            this._header = this._istream.readFrame();
        }
        catch (JavaLayerException e) {
            throw new IOException(e.toString());
        }
        this._decoder = new Decoder();
    }

    @Override
    public int getFormat() {
        return 4355;
    }

    @Override
    public int getFrequency() {
        return this._header.frequency();
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        ShortBuffer sbuf = buf.asShortBuffer();
        int total = 0;
        while (sbuf.hasRemaining() && this._header != null) {
            if (this._buffer == null) {
                try {
                    this._buffer = (SampleBuffer)this._decoder.decodeFrame(this._header, this._istream);
                    this._istream.closeFrame();
                    this._header = this._istream.readFrame();
                }
                catch (JavaLayerException e) {
                    throw new IOException(e.toString());
                }
            }
            int blen = this._buffer.getBufferLength();
            int length = Math.min(sbuf.remaining(), blen - this._offset);
            sbuf.put(this._buffer.getBuffer(), this._offset, length);
            if ((this._offset += length) >= blen) {
                this._offset = 0;
                this._buffer = null;
            }
            total += length * 2;
        }
        buf.position(buf.position() + total);
        return total;
    }
}

