/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.google.common.collect.Maps;
import com.samskivert.io.PersistenceException;
import com.threerings.media.Log;
import com.threerings.media.image.ImageManager;
import com.threerings.media.tile.IMImageProvider;
import com.threerings.media.tile.ImageProvider;
import com.threerings.media.tile.NoSuchTileSetException;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileSetRepository;
import com.threerings.media.tile.TileUtil;
import com.threerings.media.tile.UniformTileSet;
import java.lang.ref.SoftReference;
import java.util.Map;

public class TileManager {
    protected ImageManager _imgr;
    protected Map<String, SoftReference<UniformTileSet>> _handcache = Maps.newHashMap();
    protected TileSetRepository _setrep;
    protected ImageProvider _defaultProvider;

    public TileManager(ImageManager imgr) {
        this._imgr = imgr;
        this._defaultProvider = new IMImageProvider(this._imgr, null);
    }

    public UniformTileSet loadTileSet(String imgPath, int width, int height) {
        return this.loadCachedTileSet("", imgPath, width, height);
    }

    public UniformTileSet loadTileSet(String rset, String imgPath, int width, int height) {
        return this.loadTileSet(this.getImageProvider(rset), rset, imgPath, width, height);
    }

    public UniformTileSet loadTileSet(ImageProvider improv, String improvKey, String imgPath, int width, int height) {
        UniformTileSet uts = this.loadCachedTileSet(improvKey, imgPath, width, height);
        uts.setImageProvider(improv);
        return uts;
    }

    public ImageProvider getImageProvider(String rset) {
        return new IMImageProvider(this._imgr, rset);
    }

    protected UniformTileSet loadCachedTileSet(String bundle, String imgPath, int width, int height) {
        UniformTileSet uts;
        String key = String.valueOf(bundle) + "::" + imgPath;
        SoftReference<UniformTileSet> ref = this._handcache.get(key);
        UniformTileSet uniformTileSet = uts = ref == null ? null : ref.get();
        if (uts == null) {
            uts = new UniformTileSet();
            uts.setImageProvider(this._defaultProvider);
            uts.setImagePath(imgPath);
            uts.setWidth(width);
            uts.setHeight(height);
            this._handcache.put(key, new SoftReference<UniformTileSet>(uts));
        }
        return uts;
    }

    public void clearCache() {
        this._handcache = Maps.newHashMap();
    }

    public void setTileSetRepository(TileSetRepository setrep) {
        this._setrep = setrep;
    }

    public TileSetRepository getTileSetRepository() {
        return this._setrep;
    }

    public TileSet getTileSet(int tileSetId) throws NoSuchTileSetException {
        if (this._setrep == null) {
            throw new NoSuchTileSetException(tileSetId);
        }
        try {
            return this._setrep.getTileSet(tileSetId);
        }
        catch (PersistenceException pe) {
            Log.log.warning((Object)"Failure loading tileset", new Object[]{"id", tileSetId, "error", pe});
            throw new NoSuchTileSetException(tileSetId);
        }
    }

    public TileSet getTileSet(String name) throws NoSuchTileSetException {
        if (this._setrep == null) {
            throw new NoSuchTileSetException(name);
        }
        try {
            return this._setrep.getTileSet(name);
        }
        catch (PersistenceException pe) {
            Log.log.warning((Object)"Failure loading tileset", new Object[]{"name", name, "error", pe});
            throw new NoSuchTileSetException(name);
        }
    }

    public Tile getTile(int fqTileId) throws NoSuchTileSetException {
        return this.getTile(TileUtil.getTileSetId(fqTileId), TileUtil.getTileIndex(fqTileId), null);
    }

    public Tile getTile(int fqTileId, TileSet.Colorizer rizer) throws NoSuchTileSetException {
        return this.getTile(TileUtil.getTileSetId(fqTileId), TileUtil.getTileIndex(fqTileId), rizer);
    }

    public Tile getTile(int tileSetId, int tileIndex, TileSet.Colorizer rizer) throws NoSuchTileSetException {
        TileSet set = this.getTileSet(tileSetId);
        return set.getTile(tileIndex, rizer);
    }
}

