/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.util.LRUHashMap;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Throttle;
import com.samskivert.util.Tuple;
import com.threerings.media.Log;
import com.threerings.media.image.AWTImageCreator;
import com.threerings.media.image.CachedVolatileMirage;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageDataProvider;
import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.Mirage;
import com.threerings.resource.ResourceManager;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ImageManager
implements ImageUtil.ImageCreator {
    protected ResourceManager _rmgr;
    protected OptimalImageCreator _icreator;
    protected LRUHashMap<ImageKey, CacheRecord> _ccache;
    protected HashSet<ImageKey> _keySet = Sets.newHashSet();
    protected Throttle _cacheStatThrottle = new Throttle(1, 300000L);
    protected ImageDataProvider _defaultProvider = new ImageDataProvider(){

        @Override
        public BufferedImage loadImage(String path) throws IOException {
            return ImageManager.this._rmgr.getImageResource(path);
        }

        @Override
        public String getIdent() {
            return "rmgr:default";
        }
    };
    protected Map<String, ImageDataProvider> _providers = Maps.newHashMap();
    protected static int DEFAULT_CACHE_SIZE = 32768;

    public ImageManager(ResourceManager rmgr, OptimalImageCreator icreator) {
        this._rmgr = rmgr;
        this._icreator = icreator;
        int icsize = this.getCacheSize();
        Log.log.debug((Object)"Creating image cache", new Object[]{"size", String.valueOf(icsize) + "k"});
        this._ccache = new LRUHashMap(icsize * 1024, (LRUHashMap.ItemSizer)new LRUHashMap.ItemSizer<CacheRecord>(){

            public int computeSize(CacheRecord value) {
                return (int)value.getEstimatedMemoryUsage();
            }
        });
        this._ccache.setTracking(true);
    }

    public ImageManager(ResourceManager rmgr, Component context) {
        this(rmgr, new AWTImageCreator(context));
    }

    public int getCacheSize() {
        return DEFAULT_CACHE_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Log.log.info((Object)"Clearing image manager cache.", new Object[0]);
        LRUHashMap<ImageKey, CacheRecord> lRUHashMap = this._ccache;
        synchronized (lRUHashMap) {
            this._ccache.clear();
        }
    }

    @Override
    public BufferedImage createImage(int width, int height, int transparency) {
        return this._icreator.createImage(width, height, transparency);
    }

    public BufferedImage getImage(String path) {
        return this.getImage(null, path, null);
    }

    public BufferedImage getImage(String path, Colorization[] zations) {
        return this.getImage(null, path, zations);
    }

    public BufferedImage getImage(String rset, String path) {
        return this.getImage(rset, path, null);
    }

    public BufferedImage getImage(String rset, String path, Colorization[] zations) {
        if (StringUtil.isBlank((String)path)) {
            String errmsg = "Invalid image path [rset=" + rset + ", path=" + path + "]";
            throw new IllegalArgumentException(errmsg);
        }
        return this.getImage(this.getImageKey(rset, path), zations);
    }

    public BufferedImage getPreparedImage(String path) {
        return this.getPreparedImage(null, path, null);
    }

    public BufferedImage getPreparedImage(String rset, String path) {
        return this.getPreparedImage(rset, path, null);
    }

    public BufferedImage getPreparedImage(String rset, String path, Colorization[] zations) {
        BufferedImage image = this.getImage(rset, path, zations);
        BufferedImage prepped = null;
        if (image != null) {
            prepped = this.createImage(image.getWidth(), image.getHeight(), image.getColorModel().getTransparency());
            Graphics2D pg = prepped.createGraphics();
            pg.drawImage((Image)image, 0, 0, null);
            pg.dispose();
        }
        return prepped;
    }

    public ImageKey getImageKey(String rset, String path) {
        return this.getImageKey(this.getDataProvider(rset), path);
    }

    public ImageKey getImageKey(ImageDataProvider daprov, String path) {
        return new ImageKey(daprov, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage(ImageKey key, Colorization[] zations) {
        CacheRecord crec = null;
        LRUHashMap<ImageKey, CacheRecord> lRUHashMap = this._ccache;
        synchronized (lRUHashMap) {
            crec = (CacheRecord)this._ccache.get((Object)key);
        }
        if (crec != null) {
            return crec.getImage(zations, this._ccache);
        }
        BufferedImage image = this.loadImage(key);
        if (image == null) {
            Log.log.warning((Object)("Failed to load image " + key + "."), new Object[0]);
            image = new BufferedImage(10, 10, 13);
        }
        crec = new CacheRecord(key, image);
        LRUHashMap<ImageKey, CacheRecord> lRUHashMap2 = this._ccache;
        synchronized (lRUHashMap2) {
            this._ccache.put((Object)key, (Object)crec);
        }
        this._keySet.add(key);
        this.reportCachePerformance();
        return crec.getImage(zations, this._ccache);
    }

    public Mirage getMirage(String rsrcPath) {
        return this.getMirage(this.getImageKey(this._defaultProvider, rsrcPath), null, null);
    }

    public Mirage getMirage(ImageKey key) {
        return this.getMirage(key, null, null);
    }

    public Mirage getMirage(ImageKey key, Rectangle bounds) {
        return this.getMirage(key, bounds, null);
    }

    public Mirage getMirage(ImageKey key, Colorization[] zations) {
        return this.getMirage(key, null, zations);
    }

    public Mirage getMirage(ImageKey key, Rectangle bounds, Colorization[] zations) {
        BufferedImage src = null;
        if (bounds == null) {
            src = this.getImage(key, zations);
            bounds = new Rectangle(0, 0, src.getWidth(), src.getHeight());
        }
        return new CachedVolatileMirage(this, key, bounds, zations);
    }

    public OptimalImageCreator getImageCreator() {
        return this._icreator;
    }

    protected ImageDataProvider getDataProvider(final String rset) {
        if (rset == null) {
            return this._defaultProvider;
        }
        ImageDataProvider dprov = this._providers.get(rset);
        if (dprov == null) {
            dprov = new ImageDataProvider(){

                @Override
                public BufferedImage loadImage(String path) throws IOException {
                    try {
                        return ImageManager.this._rmgr.getImageResource(rset, path);
                    }
                    catch (FileNotFoundException fnfe) {
                        return ImageManager.this._rmgr.getImageResource(path);
                    }
                }

                @Override
                public String getIdent() {
                    return "rmgr:" + rset;
                }
            };
            this._providers.put(rset, dprov);
        }
        return dprov;
    }

    protected BufferedImage loadImage(ImageKey key) {
        BufferedImage image = null;
        try {
            Log.log.debug((Object)("Loading image " + key + "."), new Object[0]);
            image = key.daprov.loadImage(key.path);
            if (image == null) {
                Log.log.warning((Object)("ImageDataProvider.loadImage(" + key + ") returned null."), new Object[0]);
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)("Unable to load image '" + key + "'."), new Object[]{e});
            image = this.createImage(1, 1, 1);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportCachePerformance() {
        if (this._cacheStatThrottle.throttleOp()) {
            return;
        }
        long size = 0L;
        int[] eff = null;
        LRUHashMap<ImageKey, CacheRecord> lRUHashMap = this._ccache;
        synchronized (lRUHashMap) {
            Iterator iter = this._ccache.values().iterator();
            while (iter.hasNext()) {
                size += ((CacheRecord)iter.next()).getEstimatedMemoryUsage();
            }
            eff = this._ccache.getTrackedEffectiveness();
        }
        Log.log.info((Object)"ImageManager LRU", new Object[]{"mem", String.valueOf(size / 1024L) + "k", "size", this._ccache.size(), "hits", eff[0], "misses", eff[1], "totalKeys", this._keySet.size()});
    }

    protected static class CacheRecord {
        protected ImageKey _key;
        protected BufferedImage _source;
        protected ArrayList<Tuple<Colorization[], BufferedImage>> _colorized;

        public CacheRecord(ImageKey key, BufferedImage source) {
            this._key = key;
            this._source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getImage(Colorization[] zations, LRUHashMap<ImageKey, CacheRecord> cache) {
            if (zations == null) {
                return this._source;
            }
            if (this._colorized == null) {
                this._colorized = Lists.newArrayList();
            }
            int csize = this._colorized.size();
            int ii = 0;
            while (ii < csize) {
                Tuple<Colorization[], BufferedImage> tup = this._colorized.get(ii);
                Object[] tzations = (Colorization[])tup.left;
                if (Arrays.equals(zations, tzations)) {
                    return (BufferedImage)tup.right;
                }
                ++ii;
            }
            try {
                BufferedImage cimage = ImageUtil.recolorImage(this._source, zations);
                this._colorized.add((Tuple<Colorization[], BufferedImage>)new Tuple((Object)zations, (Object)cimage));
                LRUHashMap<ImageKey, CacheRecord> lRUHashMap = cache;
                synchronized (lRUHashMap) {
                    cache.adjustSize((int)ImageUtil.getEstimatedMemoryUsage(cimage));
                }
                return cimage;
            }
            catch (Exception re) {
                Log.log.warning((Object)"Failure recoloring image", new Object[]{"source", this._key, "zations", StringUtil.toString((Object)zations), "error", re});
                return this._source;
            }
        }

        public long getEstimatedMemoryUsage() {
            long usage = ImageUtil.getEstimatedMemoryUsage(this._source);
            if (this._colorized != null) {
                for (Tuple<Colorization[], BufferedImage> tup : this._colorized) {
                    usage += ImageUtil.getEstimatedMemoryUsage((BufferedImage)tup.right);
                }
            }
            return usage;
        }

        public String toString() {
            return "[key=" + this._key + ", wid=" + this._source.getWidth() + ", hei=" + this._source.getHeight() + ", ccount=" + (this._colorized == null ? 0 : this._colorized.size()) + "]";
        }
    }

    public static class ImageKey {
        public ImageDataProvider daprov;
        public String path;

        protected ImageKey(ImageDataProvider daprov, String path) {
            this.daprov = daprov;
            this.path = path;
        }

        public int hashCode() {
            return this.path.hashCode() ^ this.daprov.getIdent().hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ImageKey)) {
                return false;
            }
            ImageKey okey = (ImageKey)other;
            return okey.daprov.getIdent().equals(this.daprov.getIdent()) && okey.path.equals(this.path);
        }

        public String toString() {
            return String.valueOf(this.daprov.getIdent()) + ":" + this.path;
        }
    }

    public static interface OptimalImageCreator {
        public BufferedImage createImage(int var1, int var2, int var3);
    }
}

