/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.samskivert.util.StringUtil;
import com.threerings.media.image.ImageManager;
import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.Mirage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public abstract class VolatileMirage
implements Mirage {
    protected ImageManager _imgr;
    protected Rectangle _bounds;
    protected BufferedImage _image;
    protected static final boolean IMAGE_DEBUG = false;

    protected VolatileMirage(ImageManager imgr, Rectangle bounds) {
        this._imgr = imgr;
        this._bounds = bounds;
    }

    @Override
    public void paint(Graphics2D gfx, int x, int y) {
        if (this._image == null) {
            this.createVolatileImage();
        }
        gfx.drawImage((Image)this._image, x, y, null);
    }

    public int getX() {
        return this._bounds.x;
    }

    public int getY() {
        return this._bounds.y;
    }

    @Override
    public int getWidth() {
        return this._bounds.width;
    }

    @Override
    public int getHeight() {
        return this._bounds.height;
    }

    @Override
    public boolean hitTest(int x, int y) {
        return ImageUtil.hitTest(this._image, x, y);
    }

    @Override
    public long getEstimatedMemoryUsage() {
        return ImageUtil.getEstimatedMemoryUsage(this._image.getRaster());
    }

    @Override
    public BufferedImage getSnapshot() {
        return this._image;
    }

    protected void createVolatileImage() {
        if (this._image != null) {
            this._image.flush();
        }
        this._image = this._imgr.createImage(this._bounds.width, this._bounds.height, this.getTransparency());
        this.refreshVolatileImage();
    }

    protected abstract int getTransparency();

    protected abstract void refreshVolatileImage();

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        this.toString(buf);
        return buf.append("]").toString();
    }

    protected void toString(StringBuilder buf) {
        buf.append("bounds=").append(StringUtil.toString((Object)this._bounds));
    }
}

