/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.Log;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageManager;
import com.threerings.media.image.VolatileMirage;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class CachedVolatileMirage
extends VolatileMirage {
    protected ImageManager.ImageKey _source;
    protected Colorization[] _zations;

    protected CachedVolatileMirage(ImageManager imgr, ImageManager.ImageKey source, Rectangle bounds, Colorization[] zations) {
        super(imgr, bounds);
        this._source = source;
        this._zations = zations;
        this.createVolatileImage();
    }

    @Override
    protected int getTransparency() {
        BufferedImage source = this._imgr.getImage(this._source, this._zations);
        return source == null ? 1 : source.getColorModel().getTransparency();
    }

    @Override
    protected void refreshVolatileImage() {
        Graphics gfx = null;
        try {
            try {
                BufferedImage source = this._imgr.getImage(this._source, this._zations);
                if (source != null) {
                    gfx = this._image.getGraphics();
                    BufferedImage subImg = source.getSubimage(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    gfx.drawImage(subImg, 0, 0, null);
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)("Failure refreshing mirage " + this + "."), new Object[]{e});
                if (gfx != null) {
                    gfx.dispose();
                }
            }
        }
        finally {
            if (gfx != null) {
                gfx.dispose();
            }
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", key=").append(this._source);
        buf.append(", zations=").append(this._zations);
    }
}

