/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.google.common.collect.Lists;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.StringUtil;
import com.threerings.geom.GeomUtil;
import com.threerings.media.tile.NoSuchTileSetException;
import com.threerings.media.tile.ObjectTile;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.miso.Log;
import com.threerings.miso.client.MisoScenePanel;
import com.threerings.miso.client.SceneObject;
import com.threerings.miso.data.MisoSceneModel;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.tile.BaseTile;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import com.threerings.miso.util.ObjectSet;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class SceneBlock {
    protected MisoScenePanel _panel;
    protected MisoSceneMetrics _metrics;
    protected MisoSceneModel _model;
    protected TileManager _tileMgr;
    protected Rectangle _bounds;
    protected Rectangle _sbounds;
    protected Rectangle _obounds;
    protected Polygon _footprint;
    protected TileSet _defset;
    protected BaseTile[] _base;
    protected BaseTile[] _fringe;
    protected boolean[] _covered;
    protected SceneObject[] _objects;
    protected SceneBlock[] _neighbors = new SceneBlock[DX.length];
    protected boolean _visi;
    protected boolean _wasAbandoned;
    protected static final int[] DX = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
    protected static final int[] DY = new int[]{0, -1, -1, -1, 0, 1, 1, 1};

    public SceneBlock(MisoScenePanel panel, int tx, int ty, int width, int height) {
        this(panel.getSceneModel(), panel.getSceneMetrics(), panel.getTileManager(), tx, ty, width, height);
        this._panel = panel;
    }

    public SceneBlock(MisoSceneModel model, MisoSceneMetrics metrics, TileManager tileMgr, int tx, int ty, int width, int height) {
        this._model = model;
        this._metrics = metrics;
        this._tileMgr = tileMgr;
        this._bounds = new Rectangle(tx, ty, width, height);
        this._base = new BaseTile[width * height];
        this._fringe = new BaseTile[width * height];
        this._covered = new boolean[width * height];
        this._footprint = MisoUtil.getFootprintPolygon(this._metrics, tx, ty, width, height);
    }

    public void setVisiBlock(boolean visi) {
        this._visi = visi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolve() {
        if (this._panel != null) {
            if (this._panel.getBlock(this._bounds.x, this._bounds.y) != this) {
                this._wasAbandoned = true;
                return false;
            }
            this._panel.blockResolving(this);
        }
        this._wasAbandoned = false;
        Rectangle sbounds = new Rectangle(this._footprint.getBounds());
        Rectangle obounds = null;
        long now = System.currentTimeMillis();
        int baseCount = 0;
        int fringeCount = 0;
        for (int yy = 0; yy < this._bounds.height; ++yy) {
            for (int xx = 0; xx < this._bounds.width; ++xx) {
                int x = this._bounds.x + xx;
                int y = this._bounds.y + yy;
                int fqTileId = this._model.getBaseTileId(x, y);
                if (fqTileId <= 0) continue;
                this.updateBaseTile(fqTileId, x, y);
                ++baseCount;
                int tidx = this.index(x, y);
                if (this._base[tidx] == null) continue;
                this._fringe[tidx] = this.computeFringeTile(x, y);
                ++fringeCount;
            }
        }
        long stamp = System.currentTimeMillis();
        long elapsed = stamp - now;
        if (elapsed > 500L) {
            Log.log.warning((Object)("Base and fringe resolution took long time [block=" + this + ", baseCount=" + baseCount + ", fringeCount=" + fringeCount + ", elapsed=" + elapsed + "]."), new Object[0]);
        }
        ObjectSet set = new ObjectSet();
        this._model.getObjects(this._bounds, set);
        ArrayList scobjs = Lists.newArrayList();
        now = System.currentTimeMillis();
        int ll = set.size();
        for (int ii = 0; ii < ll; ++ii) {
            SceneObject scobj = this.makeSceneObject(set.get(ii));
            if (scobj.bounds == null) continue;
            sbounds.add(scobj.bounds);
            obounds = GeomUtil.grow(obounds, scobj.bounds);
            scobjs.add(scobj);
            stamp = System.currentTimeMillis();
            elapsed = stamp - now;
            now = stamp;
            if (elapsed <= 250L) continue;
            Log.log.warning((Object)("Scene object took look time to resolve [block=" + this + ", scobj=" + scobj + ", elapsed=" + elapsed + "]."), new Object[0]);
        }
        this._objects = scobjs.toArray(new SceneObject[scobjs.size()]);
        int bsetid = this._model.getDefaultBaseTileSet();
        try {
            if (bsetid > 0) {
                this._defset = this._tileMgr.getTileSet(bsetid);
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)("Unable to fetch default base tileset [tsid=" + bsetid + ", error=" + e + "]."), new Object[0]);
        }
        SceneBlock sceneBlock = this;
        synchronized (sceneBlock) {
            this._obounds = obounds;
            this._sbounds = sbounds;
        }
        return true;
    }

    protected SceneObject makeSceneObject(ObjectInfo info) {
        return new SceneObject(this._metrics, this._tileMgr, this._panel == null ? null : this._panel.getColorizer(info), info);
    }

    protected BaseTile computeFringeTile(int tx, int ty) {
        return this._panel == null ? null : this._panel.computeFringeTile(tx, ty);
    }

    protected void wasResolved() {
        if (this._panel != null) {
            if (this._wasAbandoned) {
                this._panel.blockAbandoned(this);
            } else {
                this._panel.blockResolved(this);
            }
        }
    }

    public synchronized boolean isResolved() {
        return this._sbounds != null;
    }

    public Rectangle getBounds() {
        return this._bounds;
    }

    public Rectangle getScreenBounds() {
        return this._sbounds;
    }

    public Rectangle getObjectBounds() {
        return this._obounds;
    }

    public Polygon getFootprint() {
        return this._footprint;
    }

    public SceneObject[] getObjects() {
        return this._objects;
    }

    public BaseTile getBaseTile(int tx, int ty) {
        BaseTile tile = this._base[this.index(tx, ty)];
        if (tile == null && this._defset != null) {
            tile = (BaseTile)this._defset.getTile(TileUtil.getTileHash(tx, ty) % this._defset.getTileCount());
        }
        return tile;
    }

    public BaseTile getFringeTile(int tx, int ty) {
        return this._fringe[this.index(tx, ty)];
    }

    public void updateBaseTile(int fqTileId, int tx, int ty) {
        String errmsg = null;
        int tidx = this.index(tx, ty);
        try {
            this._base[tidx] = fqTileId <= 0 ? null : (BaseTile)this._tileMgr.getTile(fqTileId);
            this._fringe[tidx] = null;
        }
        catch (ClassCastException cce) {
            errmsg = "Scene contains non-base tile in base layer";
        }
        catch (NoSuchTileSetException nste) {
            errmsg = "Scene contains non-existent tileset";
        }
        if (errmsg != null) {
            Log.log.warning((Object)(errmsg + " [fqtid=" + fqTileId + ", x=" + tx + ", y=" + ty + "]."), new Object[0]);
        }
    }

    public void updateFringe(int tx, int ty) {
        int tidx = this.index(tx, ty);
        if (this._base[tidx] != null) {
            this._fringe[tidx] = this.computeFringeTile(tx, ty);
        }
    }

    public boolean addObject(ObjectInfo info) {
        for (SceneObject _object : this._objects) {
            if (!_object.info.equals(info)) continue;
            return false;
        }
        this._objects = (SceneObject[])ArrayUtil.append((Object[])this._objects, (Object)this.makeSceneObject(info));
        Arrays.fill(this._neighbors, null);
        return true;
    }

    public boolean deleteObject(ObjectInfo info) {
        int oidx = -1;
        for (int ii = 0; ii < this._objects.length; ++ii) {
            if (!this._objects[ii].info.equals(info)) continue;
            oidx = ii;
            break;
        }
        if (oidx == -1) {
            return false;
        }
        this._objects = (SceneObject[])ArrayUtil.splice((Object[])this._objects, (int)oidx, (int)1);
        Arrays.fill(this._neighbors, null);
        return true;
    }

    public boolean canTraverse(Object traverser, int tx, int ty) {
        if (this._covered[this.index(tx, ty)]) {
            return false;
        }
        BaseTile base = this.getBaseTile(tx, ty);
        if (base == null || !base.isPassable()) {
            return false;
        }
        BaseTile fringe = this.getFringeTile(tx, ty);
        return fringe == null || fringe.isPassable();
    }

    public void computeMemoryUsage(Map<Tile.Key, BaseTile> bases, Set<BaseTile> fringes, Map<Tile.Key, ObjectTile> objects, long[] usage) {
        for (int yy = 0; yy < this._bounds.height; ++yy) {
            for (int xx = 0; xx < this._bounds.width; ++xx) {
                int x = this._bounds.x + xx;
                int y = this._bounds.y + yy;
                int tidx = this.index(x, y);
                BaseTile base = this._base[tidx];
                if (base == null) continue;
                BaseTile sbase = bases.get(base.key);
                if (sbase == null) {
                    bases.put(base.key, base);
                    usage[0] = usage[0] + base.getEstimatedMemoryUsage();
                } else if (base != this._base[tidx]) {
                    Log.log.warning((Object)("Multiple instances of same base tile [base=" + base + ", x=" + xx + ", y=" + yy + "]."), new Object[0]);
                    usage[0] = usage[0] + base.getEstimatedMemoryUsage();
                }
                if (this._fringe[tidx] == null || fringes.contains(this._fringe[tidx])) continue;
                fringes.add(this._fringe[tidx]);
                usage[1] = usage[1] + this._fringe[tidx].getEstimatedMemoryUsage();
            }
        }
        int ocount = this._objects == null ? 0 : this._objects.length;
        for (int ii = 0; ii < ocount; ++ii) {
            SceneObject scobj = this._objects[ii];
            ObjectTile tile = objects.get(scobj.tile.key);
            if (tile == null) {
                objects.put(scobj.tile.key, scobj.tile);
                usage[2] = usage[2] + scobj.tile.getEstimatedMemoryUsage();
                continue;
            }
            if (tile == scobj.tile) continue;
            Log.log.warning((Object)("Multiple instances of same object tile: " + scobj.info + "."), new Object[0]);
            usage[2] = usage[2] + scobj.tile.getEstimatedMemoryUsage();
        }
    }

    public String toString() {
        int bx = MathUtil.floorDiv(this._bounds.x, this._bounds.width);
        int by = MathUtil.floorDiv(this._bounds.y, this._bounds.height);
        return StringUtil.coordsToString((int)bx, (int)by) + ":" + StringUtil.toString((Object)this._bounds) + ":" + (this._objects == null ? 0 : this._objects.length) + (this._visi ? ":v" : ":i");
    }

    protected final int index(int tx, int ty) {
        return (ty - this._bounds.y) * this._bounds.width + (tx - this._bounds.x);
    }

    protected void update(Map<Integer, SceneBlock> blocks) {
        boolean recover = false;
        for (int ii = 0; ii < DX.length; ++ii) {
            SceneBlock neigh = blocks.get(this.neighborKey(DX[ii], DY[ii]));
            if (neigh == this._neighbors[ii]) continue;
            this._neighbors[ii] = neigh;
            recover = recover || neigh != null;
        }
        if (recover) {
            for (SceneObject _object : this._objects) {
                this.setCovered(blocks, _object);
            }
        }
    }

    protected final int neighborKey(int dx, int dy) {
        int nx = MathUtil.floorDiv(this._bounds.x, this._bounds.width) + dx;
        int ny = MathUtil.floorDiv(this._bounds.y, this._bounds.height) + dy;
        return MisoScenePanel.compose(nx, ny);
    }

    protected final int blockKey(int tx, int ty) {
        int bx = MathUtil.floorDiv(tx, this._bounds.width);
        int by = MathUtil.floorDiv(ty, this._bounds.height);
        return MisoScenePanel.compose(bx, by);
    }

    protected void setCovered(Map<Integer, SceneBlock> blocks, SceneObject scobj) {
        int endx = scobj.info.x - scobj.tile.getBaseWidth() + 1;
        int endy = scobj.info.y - scobj.tile.getBaseHeight() + 1;
        for (int xx = scobj.info.x; xx >= endx; --xx) {
            for (int yy = scobj.info.y; yy >= endy; --yy) {
                SceneBlock block = blocks.get(this.blockKey(xx, yy));
                if (block == null) continue;
                block.setCovered(xx, yy);
            }
        }
    }

    protected void setCovered(int tx, int ty) {
        this._covered[this.index((int)tx, (int)ty)] = true;
    }
}

