/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.samskivert.util.StringUtil;
import com.threerings.media.util.Path;
import com.threerings.media.util.Pathable;
import com.threerings.media.util.TimedPath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class LinePath
extends TimedPath {
    protected Point _source;
    protected Point _dest;
    protected Point _tpos = new Point();

    public LinePath(int x1, int y1, int x2, int y2, long duration) {
        this(new Point(x1, y1), new Point(x2, y2), duration);
    }

    public LinePath(Point source, Point dest, long duration) {
        super(duration);
        this._source = source;
        this._dest = dest;
    }

    public LinePath(Point dest, long duration) {
        this(null, dest, duration);
    }

    public Path getTranslatedInstance(int x, int y) {
        if (this._source == null) {
            return new LinePath(null, new Point(this._dest.x + x, this._dest.y + y), this._duration);
        }
        return new LinePath(this._source.x + x, this._source.y + y, this._dest.x + x, this._dest.y + y, this._duration);
    }

    @Override
    public void init(Pathable pable, long timestamp) {
        super.init(pable, timestamp);
        if (this._source == null) {
            this._source = new Point(pable.getX(), pable.getY());
        }
    }

    @Override
    public boolean tick(Pathable pable, long timestamp) {
        if (timestamp >= this._startStamp + this._duration) {
            pable.setLocation(this._dest.x, this._dest.y);
            pable.pathCompleted(timestamp);
            return true;
        }
        long elapsed = timestamp - this._startStamp;
        LinePath.computePosition(this._source, this._dest, elapsed, this._duration, this._tpos);
        if (pable.getX() != this._tpos.x || pable.getY() != this._tpos.y) {
            pable.setLocation(this._tpos.x, this._tpos.y);
            return true;
        }
        return false;
    }

    @Override
    public void paint(Graphics2D gfx) {
        gfx.setColor(Color.red);
        gfx.drawLine(this._source.x, this._source.y, this._dest.x, this._dest.y);
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", src=").append(StringUtil.toString((Object)this._source));
        buf.append(", dest=").append(StringUtil.toString((Object)this._dest));
    }

    public static void computePosition(Point start, Point end, long elapsed, long duration, Point pos) {
        float pct = (float)elapsed / (float)duration;
        int travx = (int)((float)(end.x - start.x) * pct);
        int travy = (int)((float)(end.y - start.y) * pct);
        pos.setLocation(start.x + travx, start.y + travy);
    }
}

