/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.media.image.Colorization;
import com.threerings.media.tile.BaseSizableTileSet;
import com.threerings.media.tile.ObjectTile;
import com.threerings.media.tile.ObjectTileSet;
import com.threerings.media.tile.RecolorableTileSet;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.util.TileSetTrimmer;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class TrimmedObjectTileSet
extends TileSet
implements RecolorableTileSet,
BaseSizableTileSet {
    protected Rectangle[] _bounds;
    protected Rectangle[] _ometrics;
    protected Bits[] _bits;
    protected String[] _zations;
    private static final long serialVersionUID = 1L;

    @Override
    public int getTileCount() {
        return this._bounds.length;
    }

    @Override
    public Rectangle computeTileBounds(int tileIndex, Rectangle bounds) {
        bounds.setBounds(this._bounds[tileIndex]);
        return bounds;
    }

    public int getXSpot(int tileIdx) {
        return this._bits == null ? 0 : (int)this._bits[tileIdx].xspot;
    }

    public int getYSpot(int tileIdx) {
        return this._bits == null ? 0 : (int)this._bits[tileIdx].yspot;
    }

    public int getSpotOrient(int tileIdx) {
        return this._bits == null ? -1 : (int)this._bits[tileIdx].sorient;
    }

    public String[] getConstraints(int tileIdx) {
        return this._bits == null ? null : this._bits[tileIdx].constraints;
    }

    public boolean hasConstraint(int tileIdx, String constraint) {
        return this._bits == null || this._bits[tileIdx].constraints == null ? false : ListUtil.contains((Object[])this._bits[tileIdx].constraints, (Object)constraint);
    }

    @Override
    public String[] getColorizations() {
        return this._zations;
    }

    @Override
    public int getBaseWidth(int tileIdx) {
        return this._ometrics[tileIdx].width;
    }

    @Override
    public int getBaseHeight(int tileIdx) {
        return this._ometrics[tileIdx].height;
    }

    @Override
    protected Colorization[] getColorizations(int tileIndex, TileSet.Colorizer rizer) {
        Colorization[] zations = null;
        if (rizer != null && this._zations != null) {
            zations = new Colorization[this._zations.length];
            for (int ii = 0; ii < this._zations.length; ++ii) {
                zations[ii] = rizer.getColorization(ii, this._zations[ii]);
            }
        }
        return zations;
    }

    @Override
    protected Tile createTile() {
        return new ObjectTile();
    }

    @Override
    protected void initTile(Tile tile, int tileIndex, Colorization[] zations) {
        super.initTile(tile, tileIndex, zations);
        ObjectTile otile = (ObjectTile)tile;
        otile.setBase(this._ometrics[tileIndex].width, this._ometrics[tileIndex].height);
        otile.setOrigin(this._ometrics[tileIndex].x, this._ometrics[tileIndex].y);
        if (this._bits != null) {
            Bits bits = this._bits[tileIndex];
            otile.setPriority(bits.priority);
            if (bits.sorient != -1) {
                otile.setSpot(bits.xspot, bits.yspot, bits.sorient);
            }
            otile.setConstraints(bits.constraints);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", ometrics=").append(StringUtil.toString((Object)this._ometrics));
        buf.append(", bounds=").append(StringUtil.toString((Object)this._bounds));
        buf.append(", bits=").append(StringUtil.toString((Object)this._bits));
        buf.append(", zations=").append(StringUtil.toString((Object)this._zations));
    }

    public static TrimmedObjectTileSet trimObjectTileSet(ObjectTileSet source, OutputStream destImage) throws IOException {
        return TrimmedObjectTileSet.trimObjectTileSet(source, destImage, ".raw");
    }

    public static TrimmedObjectTileSet trimObjectTileSet(ObjectTileSet source, OutputStream destImage, String imgFormat) throws IOException {
        final TrimmedObjectTileSet tset = new TrimmedObjectTileSet();
        tset.setName(source.getName());
        int tcount = source.getTileCount();
        tset._bounds = new Rectangle[tcount];
        tset._ometrics = new Rectangle[tcount];
        if (source._priorities != null || source._xspots != null || source._constraints != null) {
            tset._bits = new Bits[tcount];
        }
        tset._zations = source.getColorizations();
        for (int ii = 0; ii < tcount; ++ii) {
            tset._ometrics[ii] = new Rectangle();
            if (source._xorigins != null) {
                tset._ometrics[ii].x = source._xorigins[ii];
            }
            if (source._yorigins != null) {
                tset._ometrics[ii].y = source._yorigins[ii];
            }
            tset._ometrics[ii].width = source._owidths[ii];
            tset._ometrics[ii].height = source._oheights[ii];
            if (tset._bits != null) {
                tset._bits[ii] = new Bits();
            }
            if (source._priorities != null) {
                tset._bits[ii].priority = source._priorities[ii];
            }
            if (source._xspots != null) {
                tset._bits[ii].xspot = source._xspots[ii];
                tset._bits[ii].yspot = source._yspots[ii];
                tset._bits[ii].sorient = source._sorients[ii];
            }
            if (source._constraints == null) continue;
            tset._bits[ii].constraints = source._constraints[ii];
        }
        TileSetTrimmer.TrimMetricsReceiver tmr = new TileSetTrimmer.TrimMetricsReceiver(){

            @Override
            public void trimmedTile(int tileIndex, int imageX, int imageY, int trimX, int trimY, int trimWidth, int trimHeight) {
                tset._ometrics[tileIndex].x -= trimX;
                tset._ometrics[tileIndex].y -= trimY;
                tset._bounds[tileIndex] = new Rectangle(imageX, imageY, trimWidth, trimHeight);
            }
        };
        TileSetTrimmer.trimTileSet(source, destImage, tmr, imgFormat);
        return tset;
    }

    protected static class Bits
    implements Serializable {
        public byte priority;
        public short xspot;
        public short yspot;
        public byte sorient = (byte)-1;
        public String[] constraints;
        private static final long serialVersionUID = 2L;

        protected Bits() {
        }

        public String toString() {
            return StringUtil.fieldsToString((Object)this);
        }
    }
}

