/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.image.Mirage;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class CompositeMirage
implements Mirage {
    protected Mirage[] _mirages;

    public CompositeMirage(Mirage ... mirages) {
        this._mirages = mirages;
    }

    @Override
    public long getEstimatedMemoryUsage() {
        long mem = 0L;
        for (Mirage m : this._mirages) {
            mem += m.getEstimatedMemoryUsage();
        }
        return mem;
    }

    @Override
    public int getHeight() {
        int height = 0;
        for (Mirage m : this._mirages) {
            height = Math.max(height, m.getHeight());
        }
        return height;
    }

    @Override
    public int getWidth() {
        int width = 0;
        for (Mirage m : this._mirages) {
            width = Math.max(width, m.getWidth());
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getSnapshot() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D gfx = img.createGraphics();
        try {
            for (Mirage m : this._mirages) {
                m.paint(gfx, 0, 0);
            }
        }
        finally {
            gfx.dispose();
        }
        return img;
    }

    @Override
    public boolean hitTest(int x, int y) {
        for (Mirage m : this._mirages) {
            if (!m.hitTest(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paint(Graphics2D gfx, int x, int y) {
        for (Mirage m : this._mirages) {
            m.paint(gfx, x, y);
        }
    }
}

