/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.builder;

import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.cast.ComponentClass;
import com.threerings.cast.builder.BuilderModel;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClassEditor
extends JPanel
implements ChangeListener {
    protected ComponentClass _cclass;
    protected List<Integer> _components;
    protected JLabel _clabel;
    protected BuilderModel _model;

    public ClassEditor(BuilderModel model, ComponentClass cclass, List<Integer> components) {
        this._model = model;
        this._components = components;
        this._cclass = cclass;
        VGroupLayout vgl = new VGroupLayout(VGroupLayout.STRETCH);
        vgl.setOffAxisPolicy(VGroupLayout.STRETCH);
        this.setLayout((LayoutManager)vgl);
        HGroupLayout hgl = new HGroupLayout();
        hgl.setJustification(HGroupLayout.LEFT);
        JPanel sub = new JPanel((LayoutManager)hgl);
        sub.add(new JLabel(cclass.name + ": "));
        this._clabel = new JLabel("0");
        sub.add(this._clabel);
        this.add(sub);
        int max = components.size() - 1;
        JSlider slider = new JSlider(0, 0, max, 0);
        slider.setSnapToTicks(true);
        slider.addChangeListener(this);
        this.add(slider);
        this.setSelectedComponent(0);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int val = source.getValue();
            this.setSelectedComponent(val);
            this._clabel.setText(Integer.toString(val));
        }
    }

    protected void setSelectedComponent(int idx) {
        int cid = this._components.get(idx);
        this._model.setSelectedComponent(this._cclass, cid);
    }
}

