/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.Maps;
import com.samskivert.swing.Controller;
import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.Interval;
import com.samskivert.util.ObserverList;
import com.samskivert.util.RunAnywhere;
import com.threerings.NenyaLog;
import com.threerings.media.MediaPrefs;
import com.threerings.util.KeyTranslator;
import com.threerings.util.keybd.Keyboard;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class KeyboardManager
implements KeyEventDispatcher,
AncestorListener,
WindowFocusListener {
    protected static final boolean DEBUG_EVENTS = false;
    protected static final boolean DEBUG_INTERVAL = false;
    protected static final long DEFAULT_REPEAT_DELAY = 50L;
    protected long _repeatDelay = 50L;
    protected HashIntMap<KeyInfo> _keys = new HashIntMap();
    protected HashMap<Character, KeyInfo> _chars = Maps.newHashMap();
    protected boolean _focus;
    protected boolean _enabled;
    protected Window _window;
    protected JComponent _target;
    protected KeyTranslator _xlate;
    protected ObserverList<KeyObserver> _observers = ObserverList.newFastUnsafe();
    protected KeyObserverOp _keyOp = new KeyObserverOp();
    protected boolean _nativeRepeat;
    protected boolean _shouldDisableNativeRepeat = true;
    protected static RuntimeAdjust.BooleanAdjust _debugTyping = new RuntimeAdjust.BooleanAdjust("Toggles key typed debugging", "nenya.util.keyboard", MediaPrefs.config, false);

    public KeyboardManager() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public void reset() {
        this.setEnabled(false);
        this._target = null;
        this._xlate = null;
        this._focus = false;
    }

    public void setTarget(JComponent target, KeyTranslator xlate) {
        this.setEnabled(false);
        this._target = target;
        this._xlate = xlate;
    }

    public void registerKeyObserver(KeyObserver obs) {
        this._observers.add((Object)obs);
    }

    public void removeKeyObserver(KeyObserver obs) {
        this._observers.remove((Object)obs);
    }

    public void setEnabled(boolean enabled) {
        if (enabled && this._target == null) {
            NenyaLog.log.warning((Object)"Attempt to enable uninitialized keyboard manager!", new Object[]{new Exception()});
            return;
        }
        if (enabled == this._enabled) {
            return;
        }
        if (!enabled) {
            if (Keyboard.isAvailable()) {
                Keyboard.setKeyRepeat(this._nativeRepeat);
            }
            this.releaseAllKeys();
            this._keys.clear();
            if (this._window != null) {
                this._window.removeWindowFocusListener(this);
                this._window = null;
            }
            this._target.removeAncestorListener(this);
            this._focus = false;
        } else {
            this._target.addAncestorListener(this);
            if (this._target.isShowing() && this._window == null) {
                this._window = SwingUtilities.getWindowAncestor(this._target);
                if (this._window != null) {
                    this._window.addWindowFocusListener(this);
                }
            }
            this._focus = true;
            if (Keyboard.isAvailable()) {
                this._nativeRepeat = Keyboard.isKeyRepeatEnabled();
                Keyboard.setKeyRepeat(!this._shouldDisableNativeRepeat);
            }
        }
        this._enabled = enabled;
    }

    public void setRepeatDelay(long delay) {
        this._repeatDelay = delay;
    }

    public void releaseAllKeys() {
        long now = System.currentTimeMillis();
        Iterator iter = this._keys.elements();
        while (iter.hasNext()) {
            ((KeyInfo)((Object)iter.next())).release(now);
        }
    }

    protected void gainedFocus() {
        if (Keyboard.isAvailable()) {
            Keyboard.setKeyRepeat(false);
        }
        this._focus = true;
    }

    protected void lostFocus() {
        if (Keyboard.isAvailable()) {
            Keyboard.setKeyRepeat(this._nativeRepeat);
        }
        this.releaseAllKeys();
        this._focus = false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!(this._enabled && this._focus && this._target.isShowing())) {
            return false;
        }
        switch (e.getID()) {
            case 401: {
                return this.keyPressed(e);
            }
            case 402: {
                return this.keyReleased(e);
            }
            case 400: {
                return this.keyTyped(e);
            }
        }
        return false;
    }

    protected boolean keyPressed(KeyEvent e) {
        this.logKey("keyPressed", e);
        int keyCode = e.getKeyCode();
        boolean hasCommand = this._xlate.hasCommand(keyCode);
        if (hasCommand) {
            KeyInfo info = (KeyInfo)((Object)this._keys.get(keyCode));
            if (info == null) {
                info = new KeyInfo(keyCode);
                this._keys.put(keyCode, (Object)info);
            }
            info.setPressTime(RunAnywhere.getWhen((InputEvent)e));
        }
        this.notifyObservers(401, e.getKeyCode(), RunAnywhere.getWhen((InputEvent)e));
        return hasCommand;
    }

    protected boolean keyTyped(KeyEvent e) {
        this.logKey("keyTyped", e);
        char keyChar = e.getKeyChar();
        boolean hasCommand = this._xlate.hasCommand(keyChar);
        if (hasCommand) {
            KeyInfo info;
            if (this._shouldDisableNativeRepeat) {
                this._shouldDisableNativeRepeat = false;
                if (Keyboard.isAvailable()) {
                    Keyboard.setKeyRepeat(!this._shouldDisableNativeRepeat);
                }
            }
            if ((info = this._chars.get(Character.valueOf(keyChar))) == null) {
                info = new KeyInfo(keyChar);
                this._chars.put(Character.valueOf(keyChar), info);
            }
            info.setPressTime(RunAnywhere.getWhen((InputEvent)e));
        }
        this.notifyObservers(400, e.getKeyChar(), RunAnywhere.getWhen((InputEvent)e));
        return hasCommand;
    }

    protected boolean keyReleased(KeyEvent e) {
        this.logKey("keyReleased", e);
        KeyInfo info = (KeyInfo)((Object)this._keys.get(e.getKeyCode()));
        if (info != null) {
            info.setReleaseTime(RunAnywhere.getWhen((InputEvent)e));
        }
        this.notifyObservers(402, e.getKeyCode(), RunAnywhere.getWhen((InputEvent)e));
        return info != null;
    }

    protected synchronized void notifyObservers(int id, int keyCode, long timestamp) {
        this._keyOp.init(id, keyCode, timestamp);
        this._observers.apply((ObserverList.ObserverOp)this._keyOp);
    }

    protected void logKey(String msg, KeyEvent e) {
        if (_debugTyping.getValue()) {
            int keyCode = e.getKeyCode();
            NenyaLog.log.info((Object)msg, new Object[]{"key", KeyEvent.getKeyText(keyCode)});
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
        this.gainedFocus();
        if (this._window == null) {
            this._window = SwingUtilities.getWindowAncestor(this._target);
            this._window.addWindowFocusListener(this);
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
        this.lostFocus();
        if (this._window != null) {
            this._window.removeWindowFocusListener(this);
            this._window = null;
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.gainedFocus();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.lostFocus();
    }

    protected static class KeyObserverOp
    implements ObserverList.ObserverOp<KeyObserver> {
        protected int _id;
        protected int _keyCode;
        protected long _timestamp;

        protected KeyObserverOp() {
        }

        public void init(int id, int keyCode, long timestamp) {
            this._id = id;
            this._keyCode = keyCode;
            this._timestamp = timestamp;
        }

        public boolean apply(KeyObserver observer) {
            observer.handleKeyEvent(this._id, this._keyCode, this._timestamp);
            return true;
        }
    }

    protected class KeyInfo
    extends Interval {
        protected boolean _scheduled;
        protected long _lastRelease;
        protected long _lastPress;
        protected String _pressCommand;
        protected String _releaseCommand;
        protected String _keyText;
        protected int _keyCode;
        protected char _keyChar;
        protected long _pressDelay;
        protected long _repeatDelay;

        public KeyInfo(int keyCode) {
            super(RUN_DIRECT);
            this._scheduled = false;
            this._keyCode = 0;
            this._keyCode = keyCode;
            this._keyText = KeyEvent.getKeyText(this._keyCode);
            this._pressCommand = KeyboardManager.this._xlate.getPressCommand(this._keyCode);
            this._releaseCommand = KeyboardManager.this._xlate.getReleaseCommand(this._keyCode);
            int rate = KeyboardManager.this._xlate.getRepeatRate(this._keyCode);
            this._pressDelay = rate == 0 ? 0L : 1000L / (long)rate;
            this._repeatDelay = KeyboardManager.this._xlate.getRepeatDelay(this._keyCode);
        }

        public KeyInfo(char keyChar) {
            super(RUN_DIRECT);
            this._scheduled = false;
            this._keyCode = 0;
            this._keyChar = keyChar;
            this._keyText = "" + this._keyChar;
            this._pressCommand = KeyboardManager.this._xlate.getPressCommand(this._keyChar);
            this._releaseCommand = KeyboardManager.this._xlate.getReleaseCommand(this._keyChar);
            int rate = KeyboardManager.this._xlate.getRepeatRate(this._keyChar);
            this._pressDelay = rate == 0 ? 0L : 1000L / (long)rate;
            this._repeatDelay = KeyboardManager.this._xlate.getRepeatDelay(this._keyChar);
        }

        public boolean isCharacterBased() {
            return this._keyCode == 0;
        }

        public synchronized void setPressTime(long time) {
            if (_debugTyping.getValue()) {
                NenyaLog.log.info((Object)"setPressTime", new Object[]{"time", time, "this", this, "lastPress", this._lastPress, "lastRelease", this._lastRelease, "pressCommand", this._pressCommand, "releaseCommand", this._releaseCommand, "pressDelay", this._pressDelay, "repeatDelay", this._repeatDelay, "scheduled", this._scheduled});
            }
            if (this._lastPress == 0L && this._pressCommand != null) {
                this.postPress(time);
            }
            if (!this._scheduled && (this._pressDelay > 0L || this.isCharacterBased())) {
                if (this._repeatDelay > 0L) {
                    this.schedule(this._repeatDelay, this._pressDelay);
                } else {
                    this.schedule(this._pressDelay, true);
                }
                this._scheduled = true;
            }
            this._lastPress = time;
            this._lastRelease = time;
        }

        public synchronized void setReleaseTime(long time) {
            this.release(time);
            this._lastRelease = time;
            if (_debugTyping.getValue()) {
                NenyaLog.log.info((Object)"setReleaseTime", new Object[]{"time", time, "this", this, "lastPress", this._lastPress, "lastRelease", this._lastRelease, "pressCommand", this._pressCommand, "releaseCommand", this._releaseCommand, "pressDelay", this._pressDelay, "repeatDelay", this._repeatDelay, "scheduled", this._scheduled});
            }
            if (this._lastPress == this._lastRelease) {
                this.release(time);
            }
        }

        public synchronized void release(long timestamp) {
            if (_debugTyping.getValue()) {
                NenyaLog.log.info((Object)"release", new Object[]{"time", timestamp, "this", this, "lastPress", this._lastPress, "lastRelease", this._lastRelease, "pressCommand", this._pressCommand, "releaseCommand", this._releaseCommand, "pressDelay", this._pressDelay, "repeatDelay", this._repeatDelay, "scheduled", this._scheduled});
            }
            if (this._lastPress == 0L) {
                return;
            }
            if (this._scheduled) {
                this.cancel();
                this._scheduled = false;
            }
            if (this._releaseCommand != null) {
                this.postRelease(timestamp);
            }
            this._lastRelease = 0L;
            this._lastPress = 0L;
        }

        public synchronized void expired() {
            long now = System.currentTimeMillis();
            long deltaPress = now - this._lastPress;
            long deltaRelease = now - this._lastRelease;
            if (_debugTyping.getValue()) {
                NenyaLog.log.info((Object)"expired", new Object[]{"time", now, "this", this, "lastPress", this._lastPress, "lastRelease", this._lastRelease, "pressCommand", this._pressCommand, "releaseCommand", this._releaseCommand, "pressDelay", this._pressDelay, "repeatDelay", this._repeatDelay, "scheduled", this._scheduled, "deltaPress", deltaPress, "deltaRelease", deltaRelease});
            }
            if (this._lastRelease != this._lastPress) {
                this.release(now);
            } else if (this._lastPress != 0L) {
                if (!this.isCharacterBased()) {
                    if (this._pressCommand != null) {
                        this.postPress(now);
                    }
                } else {
                    this.release(now);
                }
            }
        }

        protected void postPress(long timestamp) {
            if (_debugTyping.getValue()) {
                NenyaLog.log.info((Object)"postPress", new Object[]{"time", timestamp, "this", this, "lastPress", this._lastPress, "lastRelease", this._lastRelease, "pressCommand", this._pressCommand, "releaseCommand", this._releaseCommand, "pressDelay", this._pressDelay, "repeatDelay", this._repeatDelay, "scheduled", this._scheduled});
            }
            if (!this.isCharacterBased()) {
                KeyboardManager.this.notifyObservers(401, this._keyCode, timestamp);
            } else {
                KeyboardManager.this.notifyObservers(400, this._keyChar, timestamp);
            }
            Controller.postAction((Component)KeyboardManager.this._target, (String)this._pressCommand);
        }

        protected void postRelease(long timestamp) {
            if (_debugTyping.getValue()) {
                NenyaLog.log.info((Object)"postRelease", new Object[]{"time", timestamp, "this", this, "lastPress", this._lastPress, "lastRelease", this._lastRelease, "pressCommand", this._pressCommand, "releaseCommand", this._releaseCommand, "pressDelay", this._pressDelay, "repeatDelay", this._repeatDelay, "scheduled", this._scheduled});
            }
            KeyboardManager.this.notifyObservers(402, this._keyCode, timestamp);
            Controller.postAction((Component)KeyboardManager.this._target, (String)this._releaseCommand);
        }

        public String toString() {
            return "[key=" + this._keyText + ", charBased=" + this.isCharacterBased() + "]";
        }
    }

    public static interface KeyObserver {
        public void handleKeyEvent(int var1, int var2, long var3);
    }
}

