/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource;

import com.samskivert.io.StreamUtil;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class FastImageIO {
    public static final String FILE_SUFFIX = ".raw";
    protected static int[] _cmap;
    protected static Point _origin;

    public static boolean canWrite(BufferedImage image) {
        return image.getColorModel() instanceof IndexColorModel && image.getRaster().getDataBuffer() instanceof DataBufferByte;
    }

    public static void write(BufferedImage image, OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        int width = image.getWidth();
        int height = image.getHeight();
        dout.writeInt(width);
        dout.writeInt(height);
        IndexColorModel cmodel = (IndexColorModel)image.getColorModel();
        int tpixel = cmodel.getTransparentPixel();
        dout.writeInt(tpixel);
        int msize = cmodel.getMapSize();
        int[] map = new int[msize];
        cmodel.getRGBs(map);
        dout.writeInt(msize);
        for (int element : map) {
            dout.writeInt(element);
        }
        DataBufferByte dbuf = (DataBufferByte)image.getRaster().getDataBuffer();
        byte[] data = dbuf.getData();
        if (data.length != width * height) {
            String errmsg = "Raster data not same size as image! [" + width + "x" + height + " != " + data.length + "]";
            throw new IllegalStateException(errmsg);
        }
        dout.write(data);
        dout.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel fchan = raf.getChannel();
        try {
            MappedByteBuffer mbuf = fchan.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            BufferedImage bufferedImage = FastImageIO.read(mbuf);
            return bufferedImage;
        }
        finally {
            fchan.close();
            raf.close();
        }
    }

    public static BufferedImage read(InputStream in) throws IOException {
        return FastImageIO.read(ByteBuffer.wrap(StreamUtil.toByteArray((InputStream)in)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(ByteBuffer byteBuffer) throws IOException {
        IndexColorModel cmodel;
        IntBuffer ibuf = byteBuffer.asIntBuffer();
        int width = ibuf.get();
        int height = ibuf.get();
        ibuf.get();
        int msize = ibuf.get();
        if (width > Short.MAX_VALUE || width < 0 || height > Short.MAX_VALUE || height < 0) {
            throw new IOException("Bogus image size " + width + "x" + height);
        }
        Point point = _origin;
        synchronized (point) {
            if (_cmap == null || _cmap.length < msize) {
                _cmap = new int[msize];
            }
            ibuf.get(_cmap, 0, msize);
            cmodel = new IndexColorModel(8, msize, _cmap, 0, 0, null);
        }
        byteBuffer.position(ibuf.position() * 4);
        byte[] data = new byte[width * height];
        byteBuffer.get(data);
        DataBufferByte dbuf = new DataBufferByte(data, data.length, 0);
        int[] offsets = new int[]{0};
        PixelInterleavedSampleModel smodel = new PixelInterleavedSampleModel(0, width, height, 1, width, offsets);
        WritableRaster raster = WritableRaster.createWritableRaster(smodel, dbuf, _origin);
        return new BufferedImage(cmodel, raster, false, null);
    }

    static {
        _origin = new Point(0, 0);
    }
}

