/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource;

import com.samskivert.io.StreamUtil;
import com.samskivert.net.PathUtil;
import com.threerings.resource.FastImageIO;
import com.threerings.resource.Handler;
import com.threerings.resource.Log;
import com.threerings.resource.ResourceManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public abstract class AbstractResourceManager
implements ResourceManager {
    protected LocaleHandler _localeHandler;

    protected Properties loadConfig(String configPath) throws IOException {
        Properties config = new Properties();
        try {
            config.load(this.getResource(configPath));
        }
        catch (Exception e) {
            String errmsg = "Unable to load resource manager config, cpath=" + configPath + "]";
            Log.log.warning((Object)(errmsg + "."), new Object[]{e});
            throw new IOException(errmsg);
        }
        return config;
    }

    @Override
    public void activateResourceProtocol() {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Handler.registerHandler(AbstractResourceManager.this);
                    return null;
                }
            });
        }
        catch (SecurityException se) {
            Log.log.info((Object)"Running in sandbox. Unable to bind rsrc:// handler.", new Object[0]);
        }
    }

    @Override
    public void setLocalePrefix(final String prefix) {
        this.setLocaleHandler(new LocaleHandler(){

            @Override
            public String getLocalePath(String path) {
                return PathUtil.appendPath((String)prefix, (String)path);
            }
        });
    }

    public void setLocaleHandler(LocaleHandler localeHandler) {
        this._localeHandler = localeHandler;
    }

    protected InputStream getInputStreamFromClasspath(final String fullyQualifiedPath) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return AbstractResourceManager.class.getResourceAsStream(fullyQualifiedPath);
            }
        });
    }

    protected String getLocalePath(String path) {
        return this._localeHandler == null ? null : this._localeHandler.getLocalePath(path);
    }

    public static BufferedImage loadImage(InputStream iis, boolean useFastIO) throws IOException {
        if (iis == null) {
            return null;
        }
        if (useFastIO) {
            return FastImageIO.read(iis);
        }
        return ImageIO.read(iis);
    }

    protected static BufferedImage loadImage(InputStream iis) throws IOException {
        BufferedImage image;
        block4: {
            if (iis instanceof ImageInputStream) {
                image = ImageIO.read(iis);
            } else {
                MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(iis);
                image = ImageIO.read(mciis);
                try {
                    mciis.close();
                }
                catch (IOException ioe) {
                    if ("closed".equals(ioe.getMessage())) break block4;
                    Log.log.warning((Object)("Failure closing image input '" + iis + "'."), new Object[]{ioe});
                }
            }
        }
        StreamUtil.close((InputStream)iis);
        return image;
    }

    public static interface LocaleHandler {
        public String getLocalePath(String var1);
    }
}

