/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.samskivert.util.BasicRunQueue;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.ResultListener;
import com.samskivert.util.RunQueue;
import com.threerings.media.FrameManager;
import com.threerings.media.Log;
import com.threerings.media.sound.JavaSoundPlayer;
import com.threerings.media.sound.SoundLoader;
import com.threerings.media.sound.SoundPlayer;
import com.threerings.media.timer.MediaTimer;
import com.threerings.openal.Clip;
import com.threerings.openal.ClipBuffer;
import com.threerings.openal.ClipProvider;
import com.threerings.openal.OggStreamDecoder;
import com.threerings.openal.Sound;
import com.threerings.openal.SoundGroup;
import com.threerings.openal.SoundManager;
import com.threerings.openal.Stream;
import com.threerings.openal.StreamDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.lwjgl.util.WaveData;

public class OpenALSoundPlayer
extends SoundPlayer
implements ClipProvider {
    protected static final int STREAM_UPDATE_INTERVAL = 100;
    protected TickingQueue _ticker = new TickingQueue();
    protected Map<String, ClipBuffer> _locked = Maps.newHashMap();
    protected SoundLoader _loader;
    protected SoundGroup _group;
    protected SoundManager _alSoundManager;
    protected final int SOURCE_COUNT = 10;

    public OpenALSoundPlayer(SoundLoader loader) {
        this._loader = loader;
        try {
            this._alSoundManager = this.createSoundManager();
            this._group = this._alSoundManager.createGroup(this, 10);
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Unable to initialize OpenAL", new Object[]{"cause", t});
        }
        this._ticker.start();
    }

    @Override
    public Clip loadClip(String path) throws IOException {
        int bundleEnd = path.lastIndexOf(":");
        InputStream sound = this._loader.getSound(path.substring(0, bundleEnd), path.substring(bundleEnd + 1));
        if (path.endsWith(".ogg")) {
            try {
                int read;
                AudioInputStream instream = JavaSoundPlayer.setupAudioStream(sound);
                ByteArrayOutputStream outstream = new ByteArrayOutputStream();
                byte[] buf = new byte[16384];
                do {
                    if ((read = instream.read(buf, 0, buf.length)) < 0) continue;
                    outstream.write(buf, 0, read);
                } while (read >= 0);
                byte[] audio = outstream.toByteArray();
                AudioFormat format = instream.getFormat();
                long length = audio.length / format.getFrameSize();
                instream = new AudioInputStream(new ByteArrayInputStream(audio), format, length);
                outstream = new ByteArrayOutputStream();
                AudioSystem.write(instream, AudioFileFormat.Type.WAVE, outstream);
                sound = new ByteArrayInputStream(outstream.toByteArray());
            }
            catch (Exception e) {
                Log.log.warning((Object)"Error decompressing audio clip", new Object[]{"path", path, e});
                return new Clip();
            }
        }
        return new Clip(WaveData.create((InputStream)sound));
    }

    public SoundLoader getSoundLoader() {
        return this._loader;
    }

    @Override
    public RunQueue getSoundQueue() {
        return this._ticker;
    }

    @Override
    public void setClipVolume(final float vol) {
        super.setClipVolume(vol);
        this.getSoundQueue().postRunnable(new Runnable(){

            @Override
            public void run() {
                OpenALSoundPlayer.this._alSoundManager.setBaseGain(vol);
            }
        });
    }

    @Override
    public void lock(String pkgPath, String ... keys) {
        for (String key : keys) {
            for (final String path : this.getPaths(pkgPath, key)) {
                this.getSoundQueue().postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (OpenALSoundPlayer.this._locked.containsKey(path)) {
                            return;
                        }
                        OpenALSoundPlayer.this._alSoundManager.loadClip(OpenALSoundPlayer.this, path, new ClipBuffer.Observer(){

                            @Override
                            public void clipFailed(ClipBuffer buffer) {
                                Log.log.warning((Object)"Unable to load sound", new Object[]{"path", path});
                            }

                            @Override
                            public void clipLoaded(ClipBuffer buffer) {
                                OpenALSoundPlayer.this._locked.put(path, buffer);
                            }
                        });
                    }
                });
            }
        }
    }

    @Override
    public void unlock(final String pkgPath, String ... keys) {
        for (final String key : keys) {
            this.getSoundQueue().postRunnable(new Runnable(){

                @Override
                public void run() {
                    for (String path : OpenALSoundPlayer.this.getPaths(pkgPath, key)) {
                        OpenALSoundPlayer.this._locked.remove(path);
                    }
                }
            });
        }
    }

    public void stream(final String bundle, final String path, final boolean loop, final ResultListener<Stream> listener) throws IOException {
        if (!path.endsWith(".ogg")) {
            Log.log.warning((Object)"Unknown file type for streaming", new Object[]{"bundle", bundle, "path", path});
            return;
        }
        InputStream rsrc = this._loader.getSound(bundle, path);
        final OggStreamDecoder dec = new OggStreamDecoder();
        ((StreamDecoder)dec).init(rsrc);
        this.getSoundQueue().postRunnable(new Runnable(){

            @Override
            public void run() {
                Stream s = new Stream(OpenALSoundPlayer.this._alSoundManager){
                    protected float _streamGain;
                    {
                        this._streamGain = 1.0f;
                    }

                    @Override
                    protected void update(float time) {
                        super.update(time);
                        if (this._state != 4114) {
                            return;
                        }
                        super.setGain(OpenALSoundPlayer.this._clipVol * this._streamGain);
                    }

                    @Override
                    public void setGain(float gain) {
                        this._streamGain = gain;
                        super.setGain(OpenALSoundPlayer.this._clipVol * this._streamGain);
                    }

                    @Override
                    protected int getFormat() {
                        return dec.getFormat();
                    }

                    @Override
                    protected int getFrequency() {
                        return dec.getFrequency();
                    }

                    @Override
                    protected int populateBuffer(ByteBuffer buf) throws IOException {
                        int read = dec.read(buf);
                        if (buf.hasRemaining() && loop) {
                            dec.init(OpenALSoundPlayer.this._loader.getSound(bundle, path));
                            read = Math.max(0, read);
                            read += dec.read(buf);
                        }
                        return read;
                    }
                };
                s.setGain(OpenALSoundPlayer.this._clipVol);
                listener.requestCompleted((Object)s);
            }
        });
    }

    @Override
    public SoundPlayer.Frob loop(String pkgPath, String key, float pan) {
        return this.loop(pkgPath, key, pan, 1.0f);
    }

    public SoundPlayer.Frob loop(String pkgPath, String key, float pan, float gain) {
        return this.loop(null, pkgPath, key, gain, null);
    }

    public SoundPlayer.Frob loop(SoundPlayer.SoundType type, String pkgPath, String key, final float gain, final float[] pos) {
        if (!this.shouldPlay(type)) {
            return null;
        }
        final SoundGrabber loader = new SoundGrabber(pkgPath, key){

            @Override
            protected void soundLoaded() {
                this.sound.setGain(gain);
                if (pos != null) {
                    this.sound.setPosition(pos[0], pos[1], pos[2]);
                }
                this.sound.loop(true);
            }
        };
        this.getSoundQueue().postRunnable((Runnable)loader);
        return new SoundPlayer.Frob(){

            @Override
            public float getPan() {
                return 0.0f;
            }

            @Override
            public float getVolume() {
                return 0.0f;
            }

            @Override
            public void setPan(float pan) {
            }

            @Override
            public void setVolume(float vol) {
            }

            @Override
            public void stop() {
                OpenALSoundPlayer.this.getSoundQueue().postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (loader.sound != null) {
                            loader.sound.stop();
                        }
                    }
                });
            }
        };
    }

    @Override
    public void play(String pkgPath, String key, float pan) {
        this.play(pkgPath, key, pan, 1.0f);
    }

    public void play(String pkgPath, String key, float pan, float gain) {
        this.play(null, pkgPath, key, gain, null);
    }

    public boolean play(SoundPlayer.SoundType type, String pkgPath, String key, final float gain, final float[] pos) {
        if (!this.shouldPlay(type)) {
            return false;
        }
        this.getSoundQueue().postRunnable((Runnable)new SoundGrabber(pkgPath, key){

            @Override
            protected void soundLoaded() {
                this.sound.setGain(gain);
                if (pos != null) {
                    this.sound.setPosition(pos[0], pos[1], pos[2]);
                }
                this.sound.play(true);
            }
        });
        return true;
    }

    @Override
    public void shutdown() {
        this.getSoundQueue().postRunnable(new Runnable(){

            @Override
            public void run() {
                OpenALSoundPlayer.this._group.dispose();
                OpenALSoundPlayer.this._locked.clear();
                for (Stream stream : OpenALSoundPlayer.this._alSoundManager.getStreams()) {
                    stream.dispose();
                }
            }
        });
    }

    protected String[] getPaths(String pkgPath, String key) {
        String bundle = this._loader.getBundle(pkgPath);
        Preconditions.checkNotNull((Object)bundle, (String)"Unable to find the bundle name for a package [package=%s, key=%s]", (Object[])new Object[]{pkgPath, key});
        String[] names = this._loader.getPaths(pkgPath, key);
        Preconditions.checkNotNull((Object)names, (String)"No such sound [package=%s, key=%s]", (Object[])new Object[]{pkgPath, key});
        String[] paths = new String[names.length];
        for (int ii = 0; ii < paths.length; ++ii) {
            paths[ii] = bundle + ":" + names[ii];
        }
        return paths;
    }

    protected SoundManager createSoundManager() {
        return new MediaALSoundManager();
    }

    protected abstract class SoundGrabber
    implements Runnable {
        public String path;
        public Sound sound;

        public SoundGrabber(String pkgPath, String key) {
            String[] paths = OpenALSoundPlayer.this.getPaths(pkgPath, key);
            this.path = paths[RandomUtil.getInt((int)paths.length)];
        }

        @Override
        public void run() {
            this.sound = OpenALSoundPlayer.this._group.getSound(this.path);
            this.soundLoaded();
        }

        protected abstract void soundLoaded();
    }

    protected class TickingQueue
    extends BasicRunQueue {
        protected MediaTimer _timer;
        protected long _lastTick;

        public TickingQueue() {
            super("SoundPlayerQueue");
            this._timer = FrameManager.createTimer();
        }

        protected void iterate() {
            long newTime;
            long elapsed = this._timer.getElapsedMillis() - this._lastTick;
            Runnable r = elapsed >= 100L ? (Runnable)this._queue.getNonBlocking() : (Runnable)this._queue.get(100L - elapsed);
            if (OpenALSoundPlayer.this._alSoundManager == null) {
                newTime = this._timer.getElapsedMillis();
            } else {
                if (r != null) {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        Log.log.warning((Object)"Runnable posted to SoundPlayerQueue barfed.", new Object[]{t});
                    }
                }
                newTime = this._timer.getElapsedMillis();
                try {
                    OpenALSoundPlayer.this._alSoundManager.updateStreams((float)(newTime - this._lastTick) / 1000.0f);
                }
                catch (Throwable t) {
                    Log.log.warning((Object)"Updating OpenAL streams barfed.", new Object[]{t});
                }
            }
            this._lastTick = newTime;
        }
    }

    protected class MediaALSoundManager
    extends SoundManager {
        protected MediaALSoundManager() {
            super(OpenALSoundPlayer.this.getSoundQueue());
        }

        @Override
        protected ClipBuffer getClip(ClipProvider provider, String path) {
            if (OpenALSoundPlayer.this._locked.containsKey(path)) {
                return OpenALSoundPlayer.this._locked.get(path);
            }
            return super.getClip(provider, path, null);
        }
    }
}

