/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.samskivert.util.Histogram;
import com.samskivert.util.LoopingThread;
import com.samskivert.util.Queue;
import com.threerings.miso.Log;
import com.threerings.miso.client.SceneBlock;
import java.awt.EventQueue;

public class SceneBlockResolver
extends LoopingThread {
    protected Queue<SceneBlock> _queue = new Queue();
    protected boolean _resolving = true;
    protected Histogram _histo = new Histogram(0, 25, 100);
    protected static final long LONG_RESOLVE_TIME = 500L;

    public SceneBlockResolver() {
        super("SceneBlockResolver");
    }

    public void resolveBlock(SceneBlock block, boolean hipri) {
        Log.log.debug((Object)"Queueing block for resolution", new Object[]{"block", block, "hipri", hipri});
        if (hipri) {
            this._queue.prepend((Object)block);
        } else {
            this._queue.append((Object)block);
        }
    }

    public synchronized void suspendResolution() {
        this._resolving = false;
    }

    public synchronized void restoreResolution() {
        this._resolving = true;
        ((Object)((Object)this)).notify();
    }

    public int queueSize() {
        return this._queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate() {
        final SceneBlock block = (SceneBlock)this._queue.get();
        while (!this._resolving) {
            SceneBlockResolver sceneBlockResolver = this;
            synchronized (sceneBlockResolver) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException ie) {
                    Log.log.info((Object)"Resolver interrupted.", new Object[0]);
                }
            }
        }
        try {
            long start = System.currentTimeMillis();
            Log.log.debug((Object)("Resolving block " + block + "."), new Object[0]);
            if (block.resolve()) {
                Log.log.debug((Object)("Resolved block " + block + "."), new Object[0]);
            }
            long elapsed = System.currentTimeMillis() - start;
            this._histo.addValue((int)elapsed);
            if (elapsed > 500L) {
                Log.log.warning((Object)("Block took long time to resolve [block=" + block + ", elapsed=" + elapsed + "ms]."), new Object[0]);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    block.wasResolved();
                }
            });
        }
        catch (Exception e) {
            Log.log.warning((Object)("Block failed during resolution " + block + "."), new Object[]{e});
        }
    }
}

