/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.samskivert.util.RandomUtil;
import com.threerings.media.util.Path;
import com.threerings.media.util.Pathable;
import java.awt.Color;
import java.awt.Graphics2D;

public class BobblePath
implements Path {
    protected int _sx;
    protected int _sy;
    protected int _dx;
    protected int _dy;
    protected long _duration;
    protected long _updateFreq;
    protected long _stopTime;
    protected long _nextMove = 0L;

    public BobblePath(int dx, int dy, long duration) {
        this(dx, dy, duration, 1L);
    }

    public BobblePath(int dx, int dy, long duration, long updateFreq) {
        this._updateFreq = updateFreq;
        this._duration = duration;
        this.setVariance(dx, dy);
    }

    public void setVariance(int dx, int dy) {
        if (dx < 0 || dy < 0 || dx == 0 && dy == 0) {
            throw new IllegalArgumentException("Variance values must be positive, and at least one must be non-zero.");
        }
        this._dx = dx;
        this._dy = dy;
    }

    public void setUpdateFrequency(long freq) {
        this._updateFreq = freq;
    }

    public void stop() {
        this._stopTime = 0L;
    }

    @Override
    public void init(Pathable pable, long tickstamp) {
        this._sx = pable.getX();
        this._sy = pable.getY();
        this._stopTime = this._duration == -1L ? Long.MAX_VALUE : tickstamp + this._duration;
        this._nextMove = tickstamp;
    }

    @Override
    public boolean tick(Pathable pable, long tickStamp) {
        int newy;
        int newx;
        if (this._stopTime <= tickStamp) {
            boolean updated = this.updatePositionTo(pable, this._sx, this._sy);
            pable.pathCompleted(tickStamp);
            return updated;
        }
        if (this._nextMove > tickStamp) {
            return false;
        }
        while (!this.updatePositionTo(pable, newx = this._sx + RandomUtil.getInt((int)(this._dx * 2 + 1)) - this._dx, newy = this._sy + RandomUtil.getInt((int)(this._dy * 2 + 1)) - this._dy)) {
        }
        this._nextMove = tickStamp + this._updateFreq;
        return true;
    }

    @Override
    public void fastForward(long timeDelta) {
        this._stopTime += timeDelta;
        this._nextMove += timeDelta;
    }

    @Override
    public void paint(Graphics2D gfx) {
        gfx.setColor(Color.RED);
        gfx.drawRect(this._sx - this._dx, this._sy - this._dy, this._dx * 2, this._dy * 2);
    }

    @Override
    public void wasRemoved(Pathable pable) {
        pable.setLocation(this._sx, this._sy);
    }

    protected boolean updatePositionTo(Pathable pable, int x, int y) {
        if (pable.getX() == x && pable.getY() == y) {
            return false;
        }
        pable.setLocation(x, y);
        return true;
    }
}

