/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sprite;

import com.google.common.base.Predicate;
import com.samskivert.util.SortableArrayList;
import com.threerings.media.AbstractMedia;
import com.threerings.media.AbstractMediaManager;
import com.threerings.media.sprite.Sprite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SpriteManager
extends AbstractMediaManager {
    protected SortableArrayList<Sprite> _sprites;

    public void getIntersectingSprites(List<Sprite> list, Shape shape) {
        int size = this._sprites.size();
        for (int ii = 0; ii < size; ++ii) {
            Sprite sprite = (Sprite)this._sprites.get(ii);
            if (!sprite.intersects(shape)) continue;
            list.add(sprite);
        }
    }

    public void getHitSprites(List<Sprite> list, int x, int y) {
        for (int ii = this._sprites.size() - 1; ii >= 0; --ii) {
            Sprite sprite = (Sprite)this._sprites.get(ii);
            if (!sprite.hitTest(x, y)) continue;
            list.add(sprite);
        }
    }

    public Sprite getHighestHitSprite(int x, int y) {
        for (int ii = this._sprites.size() - 1; ii >= 0; --ii) {
            Sprite sprite = (Sprite)this._sprites.get(ii);
            if (!sprite.hitTest(x, y)) continue;
            return sprite;
        }
        return null;
    }

    public void addSprite(Sprite sprite) {
        if (this.insertMedia(sprite)) {
            sprite.invalidate();
        }
    }

    public List<Sprite> getSprites() {
        return Collections.unmodifiableList(this._sprites);
    }

    public Iterator<Sprite> enumerateSprites() {
        return this._sprites.iterator();
    }

    public void removeSprite(Sprite sprite) {
        this.removeMedia(sprite);
    }

    public void removeSprites(Predicate<Sprite> pred) {
        int idxoff = 0;
        int ll = this._sprites.size();
        for (int ii = 0; ii < ll; ++ii) {
            Sprite sprite = (Sprite)this._sprites.get(ii - idxoff);
            if (!pred.apply((Object)sprite)) continue;
            this._sprites.remove((Object)sprite);
            sprite.invalidate();
            sprite.shutdown();
            ++idxoff;
            if (ii > this._tickpos) continue;
            --this._tickpos;
        }
    }

    public void renderSpritePaths(Graphics2D gfx) {
        for (Sprite sprite : this._sprites) {
            sprite.paintPath(gfx);
        }
    }

    @Override
    protected SortableArrayList<? extends AbstractMedia> createMediaList() {
        this._sprites = new SortableArrayList();
        return this._sprites;
    }
}

