/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.util.RandomUtil;
import com.samskivert.util.StringUtil;
import com.threerings.media.animation.Animation;
import com.threerings.media.image.Mirage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class ExplodeAnimation
extends Animation {
    protected float _angle;
    protected float[] _sxvel;
    protected float[] _syvel;
    protected int[] _cxpos;
    protected int[] _cypos;
    protected int _cwid;
    protected int _chei;
    protected int _hcwid;
    protected int _hchei;
    protected int _chunkcount;
    protected ExplodeInfo _info;
    protected int _ox;
    protected int _oy;
    protected int _owid;
    protected int _ohei;
    protected Color _color;
    protected Mirage _image;
    protected long _start;
    protected long _end;
    protected float _alpha;
    protected Rectangle _wrect = new Rectangle();

    public ExplodeAnimation(Color color, ExplodeInfo info, int x, int y, int width, int height) {
        super(info.bounds);
        this._color = color;
        this.init(info, x, y, width, height);
    }

    public ExplodeAnimation(Mirage image, ExplodeInfo info, int x, int y, int width, int height) {
        super(info.bounds);
        this._image = image;
        this.init(info, x, y, width, height);
    }

    protected void init(ExplodeInfo info, int x, int y, int width, int height) {
        this._info = info;
        this._ox = x;
        this._oy = y;
        this._owid = width;
        this._ohei = height;
        this._info.rvel = (float)(Math.PI * 2 * (double)this._info.rvel);
        this._chunkcount = this._info.xchunk * this._info.ychunk;
        this._cxpos = new int[this._chunkcount];
        this._cypos = new int[this._chunkcount];
        this._sxvel = new float[this._chunkcount];
        this._syvel = new float[this._chunkcount];
        this._cwid = this._owid / this._info.xchunk;
        this._chei = this._ohei / this._info.ychunk;
        this._hcwid = this._cwid / 2;
        this._hchei = this._chei / 2;
        for (int ii = 0; ii < this._chunkcount; ++ii) {
            int xpos = ii % this._info.xchunk;
            int ypos = ii / this._info.xchunk;
            this._cxpos[ii] = this._ox + xpos * this._cwid;
            this._cypos[ii] = this._oy + ypos * this._chei;
            this._sxvel[ii] = RandomUtil.getFloat((float)this._info.xvel) * (xpos < this._info.xchunk / 2 ? -1.0f : 1.0f);
            this._syvel[ii] = -RandomUtil.getFloat((float)this._info.yvel);
        }
        this._angle = 0.0f;
    }

    @Override
    public void fastForward(long timeDelta) {
        if (this._start > 0L) {
            this._start += timeDelta;
            this._end += timeDelta;
        }
    }

    @Override
    public void tick(long timestamp) {
        if (this._start == 0L) {
            this._start = timestamp;
            if (this._info.delay != -1L) {
                this._end = this._start + this._info.delay;
            }
        }
        long msecs = timestamp - this._start;
        if (this._info.delay != -1L) {
            float pctdone = (float)msecs / (float)this._info.delay;
            this._alpha = Math.max(0.1f, Math.min(1.0f, 1.0f - pctdone));
        }
        int inside = 0;
        for (int ii = 0; ii < this._chunkcount; ++ii) {
            int xtrav = (int)(this._sxvel[ii] * (float)msecs);
            int ytrav = (int)(this._syvel[ii] * (float)msecs + 0.5f * this._info.yacc * (float)(msecs * msecs));
            int xpos = ii % this._info.xchunk;
            int ypos = ii / this._info.xchunk;
            this._cxpos[ii] = this._ox + xpos * this._cwid + xtrav;
            this._cypos[ii] = this._oy + ypos * this._chei + ytrav;
            this._wrect.setBounds(this._cxpos[ii], this._cypos[ii], this._cwid, this._chei);
            if (!this._bounds.intersects(this._wrect)) continue;
            ++inside;
        }
        this._angle += this._info.rvel;
        this._finished = inside == 0 || this._info.delay != -1L && timestamp >= this._end;
        this.invalidate();
    }

    @Override
    public void paint(Graphics2D gfx) {
        Shape oclip = gfx.getClip();
        Composite ocomp = null;
        if (this._info.delay != -1L) {
            ocomp = gfx.getComposite();
            gfx.setComposite(AlphaComposite.getInstance(3, this._alpha));
        }
        for (int ii = 0; ii < this._chunkcount; ++ii) {
            int xpos = ii % this._info.xchunk;
            int ypos = ii / this._info.xchunk;
            int xoff = -(xpos * this._cwid);
            int yoff = -(ypos * this._chei);
            int tx = this._cxpos[ii] + this._hcwid;
            int ty = this._cypos[ii] + this._hchei;
            gfx.translate(tx, ty);
            gfx.rotate(this._angle);
            if (this._image != null) {
                gfx.clipRect(-this._hcwid, -this._hchei, this._cwid, this._chei);
                this._image.paint(gfx, -this._hcwid + xoff, -this._hchei + yoff);
            } else {
                gfx.setColor(this._color);
                gfx.fillRect(-this._hcwid, -this._hchei, this._cwid, this._chei);
            }
            gfx.rotate(-this._angle);
            gfx.translate(-tx, -ty);
            gfx.setClip(oclip);
        }
        if (this._info.delay != -1L) {
            gfx.setComposite(ocomp);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", ox=").append(this._ox);
        buf.append(", oy=").append(this._oy);
        buf.append(", cwid=").append(this._cwid);
        buf.append(", chei=").append(this._chei);
        buf.append(", hcwid=").append(this._hcwid);
        buf.append(", hchei=").append(this._hchei);
        buf.append(", chunkcount=").append(this._chunkcount);
        buf.append(", info=").append(this._info);
    }

    public static class ExplodeInfo {
        public Rectangle bounds;
        public int xchunk;
        public int ychunk;
        public float xvel;
        public float yvel;
        public float yacc;
        public float rvel;
        public long delay;

        public String toString() {
            return StringUtil.fieldsToString((Object)this);
        }
    }
}

