/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.util.RandomUtil;
import com.threerings.media.animation.Animation;
import com.threerings.media.image.Mirage;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class BobbleAnimation
extends Animation {
    protected int _x;
    protected int _y;
    protected int _rx;
    protected int _ry;
    protected int _sx;
    protected int _sy;
    protected Mirage _image;
    protected long _duration;
    protected long _end;

    public BobbleAnimation(Mirage image, int sx, int sy, int rx, int ry, int duration) {
        super(new Rectangle(sx - rx, sy - ry, image.getWidth() + rx, image.getHeight() + ry));
        this._image = image;
        this._sx = sx;
        this._sy = sy;
        this._rx = rx;
        this._ry = ry;
        this._duration = duration;
    }

    @Override
    public void tick(long tickStamp) {
        if (this._end == 0L) {
            this._end = tickStamp + this._duration;
        }
        this._finished = tickStamp >= this._end;
        this.invalidate();
        int dx = RandomUtil.getInt((int)this._rx);
        int dy = RandomUtil.getInt((int)this._ry);
        this._x = this._sx + dx * (RandomUtil.getBoolean() ? -1 : 1);
        this._y = this._sy + dy * (RandomUtil.getBoolean() ? -1 : 1);
    }

    @Override
    public void fastForward(long timeDelta) {
        this._end += timeDelta;
    }

    @Override
    public void paint(Graphics2D gfx) {
        this._image.paint(gfx, this._x, this._y);
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", x=").append(this._x);
        buf.append(", y=").append(this._y);
        buf.append(", rx=").append(this._rx);
        buf.append(", ry=").append(this._ry);
        buf.append(", sx=").append(this._sx);
        buf.append(", sy=").append(this._sy);
    }
}

