/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.chat;

import com.google.common.collect.Lists;
import com.samskivert.swing.Label;
import com.samskivert.util.Tuple;
import com.threerings.NenyaLog;
import com.threerings.chat.ChatGlyph;
import com.threerings.chat.ChatLogic;
import com.threerings.chat.ChatOverlay;
import com.threerings.crowd.chat.client.HistoryList;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.SystemMessage;
import com.threerings.crowd.chat.data.TellFeedbackMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.media.VirtualMediaPanel;
import com.threerings.util.MessageBundle;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SubtitleChatOverlay
extends ChatOverlay
implements ChangeListener,
HistoryList.Observer {
    protected HistoryList _history;
    protected boolean _overrideHistory;
    protected List<ChatGlyph> _showingHistory = Lists.newArrayList();
    protected JScrollBar _scrollbar;
    protected boolean _laidout;
    protected BoundedRangeModel _historyModel = null;
    protected List<ChatGlyph> _subtitles = Lists.newArrayList();
    protected int _subtitleHeight;
    protected boolean _subtitlesFill;
    protected int _subtitleXSpacing;
    protected int _subtitleYSpacing;
    protected long _lastExpire;
    protected boolean _histOffsetFinal = false;
    boolean _settingBar = false;
    protected int _histOffset = 0;
    protected int _historyExtent;
    protected static final int SUBTITLE_HEIGHT_GUESS = 16;
    protected static final int ICON_PADDING = 4;
    protected static final int PAD = 10;

    public SubtitleChatOverlay(CrowdContext ctx, ChatLogic logic, JScrollBar bar, int subtitleHeight) {
        this(ctx, logic, bar, subtitleHeight, false, 8, 8);
    }

    public SubtitleChatOverlay(CrowdContext ctx, ChatLogic logic, JScrollBar bar) {
        this(ctx, logic, bar, false);
    }

    public SubtitleChatOverlay(CrowdContext ctx, ChatLogic logic, JScrollBar bar, boolean full) {
        this(ctx, logic, bar, 0, true, full ? 8 : 3, full ? 8 : 4);
    }

    public SubtitleChatOverlay(CrowdContext ctx, ChatLogic logic, JScrollBar bar, boolean full, boolean overrideHistory) {
        this(ctx, logic, bar, full);
        this._overrideHistory = overrideHistory;
    }

    public void historyUpdated(int adjustment) {
        if (adjustment != 0) {
            int nn = this._showingHistory.size();
            for (int ii = 0; ii < nn; ++ii) {
                ChatGlyph cg = this._showingHistory.get(ii);
                cg.histIndex -= adjustment;
            }
            this.resetHistoryOffset();
        }
        if (this.isLaidOut() && this.isHistoryMode()) {
            int val = this._historyModel.getValue();
            this.updateHistBar(val - adjustment);
            if (val != this._historyModel.getValue() || adjustment != 0 || !this._histOffsetFinal) {
                this.figureCurrentHistory();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this._settingBar) {
            this.figureCurrentHistory();
        }
    }

    public void clear() {
        this.clearGlyphs(this._subtitles);
    }

    public boolean displayMessage(ChatMessage message, boolean alreadyDisplayed) {
        if (!this.isLaidOut()) {
            return false;
        }
        Graphics2D gfx = this.getTargetGraphics();
        if (gfx != null) {
            this.displayMessage(message, gfx);
            gfx.dispose();
            return true;
        }
        return false;
    }

    @Override
    public void viewDidScroll(int dx, int dy) {
        super.viewDidScroll(dx, dy);
        this.viewDidScroll(this._subtitles, dx, dy);
        this.viewDidScroll(this._showingHistory, dx, dy);
    }

    @Override
    public void added(VirtualMediaPanel target) {
        super.added(target);
        this._history.addObserver((HistoryList.Observer)this);
        if (this._overrideHistory) {
            this.setHistoryEnabled(true);
            return;
        }
    }

    @Override
    public void layout() {
        int index;
        if (this._target == null) {
            NenyaLog.log.warning((Object)(this + " laid out without target?"), new Object[]{new Exception()});
            return;
        }
        Rectangle vbounds = this._target.getViewBounds();
        if (vbounds.height < 1 || vbounds.width < 1) {
            return;
        }
        this.clearGlyphs(this._subtitles);
        if (this._subtitlesFill) {
            this._subtitleHeight = vbounds.height;
        }
        this._historyExtent = (this._subtitleHeight - this._subtitleYSpacing) / 16;
        this._scrollbar.setBlockIncrement(this._historyExtent);
        long now = System.currentTimeMillis();
        int histSize = this._history.size();
        for (index = histSize - 1; index >= 0; --index) {
            ChatMessage msg = (ChatMessage)this._history.get(index);
            this._lastExpire = 0L;
            if (now > this.getChatExpire(msg.timestamp, msg.message)) break;
        }
        ++index;
        this._lastExpire = 0L;
        Graphics2D gfx = this.getTargetGraphics();
        while (index < histSize) {
            ChatMessage msg = (ChatMessage)this._history.get(index);
            if (this.shouldShowFromHistory(msg, index)) {
                this.displayMessage(msg, gfx);
            }
            ++index;
        }
        gfx.dispose();
        this._laidout = true;
        this.resetHistoryOffset();
        if (this.isHistoryMode()) {
            this.updateHistBar(histSize - 1);
            this.figureCurrentHistory();
        }
    }

    @Override
    public void setDimmed(boolean dimmed) {
        super.setDimmed(dimmed);
        this.updateDimmed(this._subtitles);
        this.updateDimmed(this._showingHistory);
    }

    @Override
    public void removed() {
        this.clearGlyphs(this._subtitles);
        this.clearGlyphs(this._showingHistory);
        super.removed();
        this._history.removeObserver((HistoryList.Observer)this);
        this.setHistoryEnabled(false);
        this._laidout = false;
    }

    protected SubtitleChatOverlay(CrowdContext ctx, ChatLogic logic, JScrollBar bar, int height, boolean fill, int xspace, int yspace) {
        super(ctx, logic);
        this._scrollbar = bar;
        this._subtitleHeight = height;
        this._subtitlesFill = fill;
        this._subtitleXSpacing = xspace;
        this._subtitleYSpacing = yspace;
        this._history = ctx.getChatDirector().getHistory();
    }

    protected void updateDimmed(List<? extends ChatGlyph> glyphs) {
        for (ChatGlyph chatGlyph : glyphs) {
            chatGlyph.setDim(this._dimmed);
        }
    }

    protected boolean isHistoryMode() {
        return this._historyModel != null;
    }

    protected Graphics2D getTargetGraphics() {
        return this._target == null ? null : (Graphics2D)this._target.getGraphics();
    }

    protected void setHistoryEnabled(boolean historyEnabled) {
        if (historyEnabled && this._historyModel == null) {
            this._historyModel = this._scrollbar.getModel();
            this._historyModel.addChangeListener(this);
            this.resetHistoryOffset();
            this.clearGlyphs(this._subtitles);
            this.updateHistBar(this._history.size() - 1);
            this.figureCurrentHistory();
        } else if (!historyEnabled && this._historyModel != null) {
            this._historyModel.removeChangeListener(this);
            this._historyModel = null;
            this.clearGlyphs(this._showingHistory);
        }
    }

    protected void viewDidScroll(List<? extends ChatGlyph> glyphs, int dx, int dy) {
        for (ChatGlyph chatGlyph : glyphs) {
            chatGlyph.viewDidScroll(dx, dy);
        }
    }

    protected void updateHistBar(int val) {
        int newmaxval;
        int oldval;
        Graphics2D gfx;
        if (!this._histOffsetFinal && this._history.size() > this._histOffset && (gfx = this.getTargetGraphics()) != null) {
            this.figureHistoryOffset(gfx);
            gfx.dispose();
        }
        int newval = (oldval = Math.max(this._histOffset, val)) >= (newmaxval = Math.max(0, this._history.size() - 1)) - 1 ? newmaxval : oldval;
        this._settingBar = true;
        this._historyModel.setRangeProperties(newval, this._historyExtent, this._histOffset, newmaxval + this._historyExtent, this._historyModel.getValueIsAdjusting());
        this._settingBar = false;
    }

    protected void resetHistoryOffset() {
        this._histOffsetFinal = false;
        this._histOffset = 0;
    }

    protected void figureHistoryOffset(Graphics2D gfx) {
        if (!this.isLaidOut()) {
            return;
        }
        int hei = this._subtitleYSpacing;
        int hsize = this._history.size();
        for (int ii = 0; ii < hsize; ++ii) {
            ChatGlyph rec = this.getHistorySubtitle(ii, gfx);
            Rectangle r = rec.getBounds();
            if ((hei += r.height) >= this._subtitleHeight) {
                this._histOffset = Math.max(0, ii - 1);
                this._histOffsetFinal = true;
                return;
            }
            hei += this.getHistorySubtitleSpacing(ii);
        }
        this._histOffset = hsize - 1;
    }

    protected void figureCurrentHistory() {
        int first = this._historyModel.getValue();
        int count = 0;
        Graphics2D gfx = null;
        if (this.isLaidOut() && !this._history.isEmpty()) {
            gfx = this.getTargetGraphics();
            if (gfx == null) {
                NenyaLog.log.warning((Object)"Can't figure current history, no graphics.", new Object[0]);
                return;
            }
            Rectangle vbounds = this._target.getViewBounds();
            int ypos = vbounds.height - this._subtitleYSpacing;
            int ii = first;
            while (ii >= 0) {
                ChatGlyph rec = this.getHistorySubtitle(ii, gfx);
                Rectangle r = rec.getBounds();
                if (count != 0 && (ypos -= r.height) <= vbounds.height - this._subtitleHeight) break;
                rec.setLocation(vbounds.x + this._subtitleXSpacing, vbounds.y + ypos);
                ypos -= this.getHistorySubtitleSpacing(ii);
                --ii;
                ++count;
            }
        }
        Iterator<ChatGlyph> itr = this._showingHistory.iterator();
        while (itr.hasNext()) {
            boolean managed;
            ChatGlyph cg = itr.next();
            boolean bl = managed = this._target != null && this._target.isManaged(cg);
            if (cg.histIndex <= first && cg.histIndex > first - count) {
                if (managed) continue;
                this._target.addAnimation(cg);
                continue;
            }
            if (managed) {
                this._target.abortAnimation(cg);
            }
            itr.remove();
        }
        if (gfx != null) {
            gfx.dispose();
        }
    }

    protected ChatGlyph getHistorySubtitle(int index, Graphics2D layoutGfx) {
        int nn = this._showingHistory.size();
        for (int ii = 0; ii < nn; ++ii) {
            ChatGlyph cg = this._showingHistory.get(ii);
            if (cg.histIndex != index) continue;
            return cg;
        }
        ChatGlyph cg = this.createHistorySubtitle(index, layoutGfx);
        cg.histIndex = index;
        cg.setDim(this._dimmed);
        this._showingHistory.add(cg);
        return cg;
    }

    protected ChatGlyph createHistorySubtitle(int index, Graphics2D layoutGfx) {
        ChatMessage message = (ChatMessage)this._history.get(index);
        int type = this.getType(message, true);
        return this.createSubtitle(message, type, layoutGfx, false);
    }

    protected int getHistorySubtitleSpacing(int index) {
        ChatMessage message = (ChatMessage)this._history.get(index);
        return this._logic.getSubtitleSpacing(this.getType(message, true));
    }

    protected boolean isLaidOut() {
        return this.isShowing() && this._laidout;
    }

    protected boolean shouldShowFromHistory(ChatMessage msg, int index) {
        return true;
    }

    protected void clearGlyphs(List<ChatGlyph> glyphs) {
        if (this._target != null) {
            int nn = glyphs.size();
            for (int ii = 0; ii < nn; ++ii) {
                ChatGlyph rec = glyphs.get(ii);
                this._target.abortAnimation(rec);
            }
        } else if (!glyphs.isEmpty()) {
            NenyaLog.log.warning((Object)"No target to abort chat animations", new Object[0]);
        }
        glyphs.clear();
    }

    protected void displayMessage(ChatMessage message, Graphics2D gfx) {
        int type = this.getType(message, false);
        if (type != -1) {
            this.displayMessage(message, type, gfx);
        }
    }

    protected void displayMessage(ChatMessage message, int type, Graphics2D layoutGfx) {
        if (this.isHistoryMode()) {
            return;
        }
        this.addSubtitle(this.createSubtitle(message, type, layoutGfx, true));
    }

    protected void addSubtitle(ChatGlyph rec) {
        Rectangle r = rec.getBounds();
        this.scrollUpSubtitles(-r.height - this._logic.getSubtitleSpacing(rec.getType()));
        Rectangle vbounds = this._target.getViewBounds();
        rec.setLocation(vbounds.x + this._subtitleXSpacing, vbounds.y + vbounds.height - this._subtitleYSpacing - r.height);
        rec.setDim(this._dimmed);
        this._subtitles.add(rec);
        this._target.addAnimation(rec);
    }

    protected ChatGlyph createSubtitle(ChatMessage message, int type, Graphics2D layoutGfx, boolean expires) {
        String text = message.message;
        Tuple<String, Boolean> finfo = this._logic.decodeFormat(type, message.getFormat());
        String format = (String)finfo.left;
        boolean quotes = (Boolean)finfo.right;
        if (format != null) {
            if (quotes) {
                text = "\"" + text + "\"";
            }
            text = " " + text;
            text = this.xlate(MessageBundle.tcompose((String)format, (Object)((UserMessage)message).getSpeakerDisplayName())) + text;
        }
        return this.createSubtitle(layoutGfx, type, message.timestamp, null, 0, text, expires);
    }

    protected ChatGlyph createSubtitle(Graphics2D gfx, int type, long timestamp, Icon icon, int indent, String text, boolean expires) {
        Dimension is = new Dimension();
        if (icon != null) {
            is.setSize(icon.getIconWidth(), icon.getIconHeight());
        }
        Rectangle vbounds = this._target.getViewBounds();
        Label label = this._logic.createLabel(text);
        label.setFont(this._logic.getFont(type));
        int paddedIconWidth = icon == null ? 0 : is.width + 4;
        label.setTargetWidth(vbounds.width - indent - paddedIconWidth - 2 * (this._subtitleXSpacing + Math.max(UIManager.getInt("ScrollBar.width"), 10)));
        label.layout(gfx);
        gfx.dispose();
        Dimension ls = label.getSize();
        Rectangle r = new Rectangle(0, 0, ls.width + indent + paddedIconWidth, Math.max(is.height, ls.height));
        r.grow(0, 1);
        Point iconpos = r.getLocation();
        iconpos.translate(indent, r.height - is.height - 1);
        Point labelpos = r.getLocation();
        labelpos.translate(indent + paddedIconWidth, 1);
        Rectangle lr = new Rectangle(r.x + indent + paddedIconWidth, r.y, r.width - indent - paddedIconWidth, ls.height + 2);
        long lifetime = Integer.MAX_VALUE;
        if (expires) {
            lifetime = this.getChatExpire(timestamp, label.getText()) - timestamp;
        }
        Shape shape = this._logic.getSubtitleShape(type, lr, r);
        return new ChatGlyph(this, type, lifetime, r.union(shape.getBounds()), shape, icon, iconpos, label, labelpos, this._logic.getOutlineColor(type));
    }

    protected long getChatExpire(long timestamp, String text) {
        long[] durations = this._logic.getDisplayDurations(this.getDisplayDurationOffset());
        long start = Math.max(timestamp, this._lastExpire);
        this._lastExpire = start + Math.min((long)text.length() * durations[0], durations[2]);
        this._lastExpire = Math.min(timestamp + durations[2], this._lastExpire);
        return Math.max(timestamp + durations[1], this._lastExpire);
    }

    protected int getDisplayDurationOffset() {
        return 1;
    }

    protected void glyphExpired(ChatGlyph glyph) {
        this._subtitles.remove(glyph);
    }

    protected int getType(ChatMessage message, boolean history) {
        String localtype = message.localtype;
        if (message instanceof TellFeedbackMessage) {
            if (((TellFeedbackMessage)message).isFailure()) {
                return 128;
            }
            return history || this.isApprovedLocalType(localtype) ? 96 : -1;
        }
        if (message instanceof UserMessage) {
            int type = this._logic.decodeType(localtype);
            if (type != 0) {
                return this._logic.adjustTypeByMode(((UserMessage)message).mode, type);
            }
            if (history) {
                return 64;
            }
        } else if (message instanceof SystemMessage) {
            if (history || this.isApprovedLocalType(localtype)) {
                switch (((SystemMessage)message).attentionLevel) {
                    case 0: {
                        return 112;
                    }
                    case 1: {
                        return 128;
                    }
                    case 2: {
                        return 144;
                    }
                }
                NenyaLog.log.warning((Object)"Unknown attention level for system message", new Object[]{"msg", message});
            }
            return -1;
        }
        NenyaLog.log.warning((Object)"Skipping received message of unknown type", new Object[]{"msg", message});
        return -1;
    }

    protected boolean isApprovedLocalType(String localtype) {
        return true;
    }

    protected void scrollUpSubtitles(int dy) {
        Rectangle vbounds = this._target.getViewBounds();
        int miny = vbounds.y + vbounds.height - this._subtitleHeight;
        Iterator<ChatGlyph> iter = this._subtitles.iterator();
        while (iter.hasNext()) {
            ChatGlyph sub = iter.next();
            sub.translate(0, dy);
            if (sub.getBounds().y > miny) continue;
            iter.remove();
            this._target.abortAnimation(sub);
        }
    }
}

