package com.threerings.resource;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public interface ResourceManager {
	
    /**
     * Notifies observers of modifications to resources (as indicated by a change to their
     * {@link File#lastModified} property).
     */
    public interface ModificationObserver
    {
        /**
         * Notes that a resource has been modified.
         *
         * @param path the path of the resource.
         * @param lastModified the resource's new timestamp.
         */
        public void resourceModified (String path, long lastModified);
    }
    
    public URL getResourceURL(String path) throws IOException;
    
	public File getResourceFile(String path);
	
	public String getResourcePath (File file);

	public InputStream getResource(String path) throws IOException;

	public BufferedImage getImageResource(String path) throws IOException;

	public InputStream getResource(String rset, String path) throws IOException;

	public BufferedImage getImageResource(String rset, String path) throws IOException;
	
	public ResourceBundle[] getResourceSet (String name);
	
	public void addModificationObserver (String path, ModificationObserver obs);
	
	public void removeModificationObserver (String path, ModificationObserver obs);
	 
	public void activateResourceProtocol();
	
	public void initResource (String resourcePath);
	/**
	 * 
	 * @param prefix
	 */
	public void setLocalePrefix (final String prefix);
	
	public void checkForModifications();
}
