/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.raz;

import com.threerings.resource.raz.RazBlock;
import com.threerings.resource.raz.RazIndexEntry;
import com.threerings.resource.raz.RazSection;
import java.io.IOException;
import java.io.InputStream;

class RazInputStream
extends InputStream {
    private long length;
    RazSection section;
    private long readerOffset;

    RazInputStream(RazIndexEntry entry, RazBlock block) throws IOException {
        this.length = entry.fileSize;
        this.section = block.getFileSection(entry.blockIndex);
    }

    @Override
    public int read() throws IOException {
        if (this.readerOffset >= this.length) {
            return -1;
        }
        ++this.readerOffset;
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.readerOffset >= this.length) {
            return -1;
        }
        if ((long)len > this.length - this.readerOffset) {
            len = (int)(this.length - this.readerOffset);
        }
        int bytesRead = 0;
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

