/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.raz;

import java.io.IOException;
import java.io.RandomAccessFile;

public class RazIndexEntry {
    public int blockIndex;
    public int hashA;
    public int hashB;
    public int flags;
    public long fileSize;
    public long fileTime;
    public int crc32;

    public RazIndexEntry(RandomAccessFile accessFile) throws IOException {
        this.blockIndex = accessFile.readInt();
        this.hashA = accessFile.readInt();
        this.hashB = accessFile.readInt();
        this.flags = accessFile.readInt();
        this.fileSize = accessFile.readLong();
        this.fileTime = accessFile.readLong();
        this.crc32 = accessFile.readInt();
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isFile() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public boolean isSingleUnit() {
        return (this.flags & 0x1000000) != 0;
    }

    public boolean isEncryptionAdjusted() {
        return (this.flags & 0x20000) != 0;
    }

    public boolean isEncrypted() {
        return (this.flags & 0x10000) != 0;
    }

    public boolean isCompressed() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isImploded() {
        return (this.flags & 0x100) != 0;
    }
}

