/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.raz;

import com.threerings.resource.raz.RazHeader;
import com.threerings.resource.raz.RazIndexEntry;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class RazIndex {
    static final int[] cryptTable = new int[65535];
    private RazHeader header;
    RandomAccessFile fileAccess;
    private final boolean rw;
    private final File file;
    private Map<Hash, RazIndexEntry> entries;

    static {
        int seed = 0x100001;
        int index1 = 0;
        while (index1 < 256) {
            int index2 = index1;
            int i = 0;
            while (i < 5) {
                seed = (seed * 125 + 3) % 0x2AAAAB;
                int temp1 = (seed & 0xFFFF) << 16;
                seed = (seed * 125 + 3) % 0x2AAAAB;
                int temp2 = seed & 0xFFFF;
                RazIndex.cryptTable[index2] = temp1 | temp2;
                ++i;
                index2 += 256;
            }
            ++index1;
        }
    }

    public RazIndex(File file) throws IOException {
        this(file, false);
    }

    public RazIndex(File file, boolean rw) throws IOException {
        this.file = file;
        this.rw = rw;
        this.openAndRead();
    }

    private void checkReadWrite() {
        if (!this.rw) {
            throw new IllegalStateException("read only");
        }
    }

    private void writeHeader() throws IOException {
        this.checkReadWrite();
        if (this.header == null) {
            this.header = new RazHeader(this.fileAccess);
        }
        this.header.wirte();
    }

    private void openAndRead() throws IOException {
        this.fileAccess = new RandomAccessFile(this.file, this.rw ? "rw" : "r");
        if (this.fileAccess.length() == 0L && this.header == null) {
            this.header = new RazHeader(this.fileAccess);
            this.header.wirte();
        }
        this.header.read();
        this.readHashTable();
    }

    private void readHashTable() throws IOException {
        this.entries = new HashMap<Hash, RazIndexEntry>();
        this.fileAccess.seek(RazHeader.HEADER_SIZE);
        if ((long)RazHeader.HEADER_SIZE >= this.fileAccess.length()) {
            return;
        }
        int i = 0;
        while (i < this.header.entries) {
            if (this.fileAccess.getFilePointer() + 1L >= this.fileAccess.length()) {
                return;
            }
            RazIndexEntry entry = new RazIndexEntry(this.fileAccess);
            Hash hash = new Hash(entry.hashA, entry.hashB);
            this.entries.put(hash, entry);
            ++i;
        }
    }

    static int hashString(String string, int hashType) {
        int seed1 = 2146271213;
        int seed2 = -286331154;
        string = string.toUpperCase();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            seed1 = cryptTable[hashType * 256 + ch] ^ seed1 + seed2;
            seed2 = ch + seed1 + seed2 + (seed2 << 5) + 3;
            ++i;
        }
        return seed1;
    }

    public static class Hash {
        private int code1;
        private int code2;

        Hash(int code1, int code2) {
            this.code1 = code1;
            this.code2 = code2;
        }

        Hash(String str) {
            this(RazIndex.hashString(str, 1), RazIndex.hashString(str, 2));
        }

        public int hashCode() {
            return this.code2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Hash) {
                Hash that = (Hash)o;
                return this.code1 == that.code1 && this.code2 == that.code2;
            }
            return false;
        }
    }
}

