/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.raz;

import com.threerings.resource.raz.BitMap;
import com.threerings.resource.raz.RazSection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RazBlock {
    public static int MAX_NUM_BLOCK = 0x300000;
    public static int BLOCK_SIZE = 1024;
    public static int LEAF_SIZE = 8;
    RandomAccessFile fileAccess;
    private File file;
    private boolean rw;
    BitMap bitMap = null;

    public RazBlock(File file, boolean rw) throws IOException {
        this.file = file;
        this.rw = rw;
        this.openAndRead();
    }

    private int getNextFreeBlock() {
        int i = this.bitMap.limitPos;
        while (i < MAX_NUM_BLOCK) {
            if (!this.bitMap.isSet(i)) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.bitMap.limitPos) {
            if (!this.bitMap.isSet(i)) {
                return i;
            }
            ++i;
        }
        return -2;
    }

    private void openAndRead() throws IOException {
        this.fileAccess = new RandomAccessFile(this.file, this.rw ? "rw" : "r");
        if (this.fileAccess.length() == 0L) {
            this.fileAccess.write(new byte[MAX_NUM_BLOCK / 8]);
            this.bitMap = new BitMap(MAX_NUM_BLOCK);
        } else {
            int[] bit = new int[MAX_NUM_BLOCK];
            int i = 0;
            while (i < MAX_NUM_BLOCK / 32) {
                bit[i] = this.fileAccess.readInt();
                ++i;
            }
            this.bitMap = new BitMap(bit);
        }
    }

    public synchronized void deleteFile(int index) throws IOException {
        int sectorSize = this.getSectorSize();
        while (index >= 0) {
            this.bitMap.unset(index);
            this.fileAccess.seek(MAX_NUM_BLOCK / 8 + (sectorSize + LEAF_SIZE) * index);
            index = this.fileAccess.readInt();
        }
    }

    public RazSection getFileSection(int index) throws IOException {
        int size;
        if (this.bitMap.isSet(index)) {
            return null;
        }
        this.fileAccess.seek(this.getOffset(index));
        RazSection section = new RazSection();
        int next = this.fileAccess.readInt();
        section.size = size = this.fileAccess.readInt();
        section.data = new byte[size];
        this.fileAccess.readFully(section.data);
        if (next >= 0) {
            section.next = this.getFileSection(next);
        }
        return section;
    }

    public long getOffset(int index) {
        return MAX_NUM_BLOCK / 8 + (this.getSectorSize() + LEAF_SIZE) * index;
    }

    public synchronized int addFile(InputStream inputStream, long fileSize) throws IOException {
        int index;
        int sectorSize = this.getSectorSize();
        byte[] data = new byte[sectorSize];
        int frist = index = this.getNextFreeBlock();
        int i = 0;
        while ((long)i < (fileSize + (long)sectorSize - 1L) / (long)sectorSize) {
            long remaining = fileSize - (long)(i * sectorSize);
            int datalen = inputStream.read(data);
            this.bitMap.set(index);
            this.fileAccess.seek(this.getOffset(index));
            if (datalen <= sectorSize && remaining <= 0L) {
                this.fileAccess.writeInt(-1);
                this.fileAccess.writeInt(datalen);
            } else {
                index = this.getNextFreeBlock();
                this.fileAccess.writeInt(index);
                this.fileAccess.writeInt(datalen);
            }
            this.fileAccess.write(data, 0, datalen);
            ++i;
        }
        return frist;
    }

    private int getSectorSize() {
        return 1024;
    }
}

