/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import java.io.IOException;

abstract class Writer {
    Writer() {
    }

    public abstract void seek(long var1) throws IOException;

    public void writeChar4(String v) throws IOException {
        if (v == null) {
            throw new NullPointerException("no string");
        }
        if (v.length() != 4) {
            throw new IllegalArgumentException("invalid string length");
        }
        this.writeByte(v.charAt(0));
        this.writeByte(v.charAt(1));
        this.writeByte(v.charAt(2));
        this.writeByte(v.charAt(3));
    }

    public void writeInt32(int v) throws IOException {
        this.writeByte(v & 0xFF);
        this.writeByte(v >>> 8 & 0xFF);
        this.writeByte(v >>> 16 & 0xFF);
        this.writeByte(v >>> 24 & 0xFF);
    }

    public void writeInt16(int v) throws IOException {
        this.writeByte(v & 0xFF);
        this.writeByte(v >>> 8 & 0xFF);
    }

    public void writeInt8(int v) throws IOException {
        this.writeByte(v & 0xFF);
    }

    protected abstract void writeByte(int var1) throws IOException;

    public void writeBlock(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            this.writeByte(b[off + i]);
            ++i;
        }
    }

    public void close() throws IOException {
    }
}

