/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import java.io.EOFException;
import java.io.IOException;

abstract class Reader {
    Reader() {
    }

    public abstract void seek(long var1) throws IOException;

    public String readChar4() throws IOException {
        int c1 = this.readByte();
        int c2 = this.readByte();
        int c3 = this.readByte();
        int c4 = this.readByte();
        if (c4 == -1) {
            throw new EOFException();
        }
        return new String(new char[]{(char)c1, (char)c2, (char)c3, (char)c4});
    }

    public int readInt32() throws IOException {
        int c1 = this.readByte();
        int c2 = this.readByte();
        int c3 = this.readByte();
        int c4 = this.readByte();
        if (c4 == -1) {
            throw new EOFException();
        }
        return c1 + c2 * 256 + c3 * 256 * 256 + c4 * 256 * 256 * 256;
    }

    public int readInt16() throws IOException {
        int c1 = this.readByte();
        int c2 = this.readByte();
        if (c2 == -1) {
            throw new EOFException();
        }
        return c1 + c2 * 256;
    }

    public int readInt8() throws IOException {
        int c1 = this.readByte();
        if (c1 == -1) {
            throw new EOFException();
        }
        return c1;
    }

    protected abstract int readByte() throws IOException;

    public int readBlock(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.readByte();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        int i = 1;
        try {
            while (i < len) {
                c = this.readByte();
                if (c != -1) {
                    b[off + i] = (byte)c;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    public void close() throws IOException {
    }
}

