/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.BlockTableEntry;
import com.threerings.resource.pack.FileWriter;
import com.threerings.resource.pack.MpqArchive;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class MpqWriter {
    private MpqArchive archive;
    private long blockOffset;
    private long fileSize;
    private int sectorSize;
    private int nextSector;
    private int[] sectorTable;
    private boolean isSingleUnit;
    private boolean isCompressed;
    private boolean isImploded;
    private CRC32 crc32;
    private MessageDigest md5;

    public MpqWriter(MpqArchive archive, long blockOffset, long fileSize) {
        if (fileSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("file too large");
        }
        this.archive = archive;
        this.blockOffset = blockOffset;
        this.fileSize = fileSize & 0xFFFFFFFFL;
        this.isCompressed = true;
    }

    public void writeSector(byte[] data) throws IOException {
        FileWriter writer;
        if (this.nextSector == 0) {
            this.prepareWrite();
        }
        if (this.crc32 != null) {
            this.crc32.update(data);
        }
        if (this.md5 != null) {
            this.md5.update(data);
        }
        int datalen = data.length;
        byte[] cdata = new byte[datalen];
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        int cdatalen = deflater.deflate(cdata);
        if (cdatalen + 1 >= datalen) {
            this.sectorTable[this.nextSector + 1] = this.sectorTable[this.nextSector] + datalen;
            writer = new FileWriter(this.archive.randomAccessFile, (long)this.archive.archiveOffset + this.blockOffset + (long)this.sectorTable[this.nextSector]);
            writer.writeBlock(data, 0, datalen);
            writer.close();
        } else {
            this.sectorTable[this.nextSector + 1] = this.sectorTable[this.nextSector] + cdatalen + 1;
            writer = new FileWriter(this.archive.randomAccessFile, (long)this.archive.archiveOffset + this.blockOffset + (long)this.sectorTable[this.nextSector]);
            writer.writeInt8(2);
            writer.writeBlock(cdata, 0, cdatalen);
            writer.close();
        }
        ++this.nextSector;
        if (this.nextSector + 1 == this.sectorTable.length - 1) {
            this.sectorTable[this.nextSector + 1] = this.sectorTable[this.nextSector];
            ++this.nextSector;
            writer = new FileWriter(this.archive.randomAccessFile, (long)this.archive.archiveOffset + this.blockOffset);
            int i = 0;
            while (i < this.sectorTable.length) {
                writer.writeInt32(this.sectorTable[i]);
                ++i;
            }
            writer.close();
        }
    }

    private void prepareWrite() {
        this.sectorSize = this.isSingleUnit ? (int)this.fileSize : this.archive.getSectorSize();
        if ((this.isCompressed || this.isImploded) && !this.isSingleUnit) {
            this.sectorTable = new int[(int)((this.fileSize + (long)this.sectorSize - 1L) / (long)this.sectorSize + 1L) + 1];
            this.sectorTable[0] = this.sectorTable.length * 4;
        }
        this.crc32 = new CRC32();
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public BlockTableEntry getBlockTableEntry() {
        if (this.fileSize == 0L && this.sectorTable == null) {
            this.prepareWrite();
            this.sectorTable[1] = this.sectorTable[0];
            ++this.nextSector;
        }
        if (this.sectorTable == null || this.nextSector + 1 != this.sectorTable.length) {
            throw new IllegalStateException("not written all sectors yet");
        }
        int flags = 0;
        flags |= Integer.MIN_VALUE;
        flags |= 0x4000000;
        if (this.isSingleUnit) {
            flags |= 0x1000000;
        }
        if (this.isCompressed) {
            flags |= 0x200;
        }
        if (this.isImploded) {
            flags |= 0x100;
        }
        BlockTableEntry blockTableEntry = new BlockTableEntry(this.blockOffset, this.sectorTable[this.nextSector], (int)this.fileSize, flags);
        if (this.crc32 != null) {
            blockTableEntry.setExtCRC32((int)this.crc32.getValue());
        }
        if (this.md5 != null) {
            blockTableEntry.setExtMD5(this.md5.digest());
        }
        return blockTableEntry;
    }
}

