/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.BZip2Reader;
import com.threerings.resource.pack.DeflateReader;
import com.threerings.resource.pack.FileReader;
import com.threerings.resource.pack.MpqFile;
import com.threerings.resource.pack.Reader;
import java.io.IOException;
import java.io.InputStream;

class MpqInputStream
extends InputStream {
    private MpqFile file;
    private Reader sectorReader;
    private long length;
    private int[] sectorTable;
    private int sectorSize;
    private int readerSector;
    private int readerOffset;

    MpqInputStream(MpqFile file) throws IOException {
        this.file = file;
        FileReader reader = new FileReader(file.mpqArchive.randomAccessFile, (long)file.mpqArchive.archiveOffset + file.blockTableEntry.getBlockOffset());
        this.length = (long)file.blockTableEntry.getFileSize() & 0xFFFFFFFFL;
        this.sectorSize = file.blockTableEntry.isSingleUnit() ? file.blockTableEntry.getFileSize() : 512 * (1 << file.mpqArchive.sectorSizeShift);
        if ((file.blockTableEntry.isCompressed() || file.blockTableEntry.isImploded()) && !file.blockTableEntry.isSingleUnit()) {
            this.sectorTable = new int[(file.blockTableEntry.getFileSize() + this.sectorSize - 1) / this.sectorSize + 1];
            int i = 0;
            while (i < this.sectorTable.length) {
                this.sectorTable[i] = reader.readInt32();
                ++i;
            }
        }
        this.readerSector = -1;
        this.readerOffset = 0;
    }

    @Override
    public int read() throws IOException {
        if ((long)this.readerOffset >= this.length) {
            return -1;
        }
        if (this.readerOffset / this.sectorSize == this.readerSector + 1) {
            this.prepareSector();
        }
        ++this.readerOffset;
        return this.sectorReader.readInt8();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if ((long)this.readerOffset >= this.length) {
            return -1;
        }
        if ((long)len > this.length - (long)this.readerOffset) {
            len = (int)(this.length - (long)this.readerOffset);
        }
        int bytesRead = 0;
        while (bytesRead < len && (long)this.readerOffset < this.length) {
            int remaining;
            int bytesAvailable;
            if (this.readerOffset / this.sectorSize == this.readerSector + 1) {
                this.prepareSector();
            }
            int toRead = (bytesAvailable = this.sectorSize - this.readerOffset % this.sectorSize) < (remaining = len - bytesRead) ? bytesAvailable : remaining;
            if ((toRead = this.sectorReader.readBlock(b, off + bytesRead, toRead)) == -1) {
                return bytesRead == 0 ? -1 : bytesRead;
            }
            this.readerOffset += toRead;
            bytesRead += toRead;
        }
        return bytesRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareSector() throws IOException {
        ++this.readerSector;
        if (this.file.blockTableEntry.isCompressed() || this.file.blockTableEntry.isImploded()) {
            int compressedSectorSize = this.file.blockTableEntry.isSingleUnit() ? this.file.blockTableEntry.getBlockSize() : this.sectorTable[this.readerSector + 1] - this.sectorTable[this.readerSector];
            long curSectorSize = this.length - (long)this.readerOffset;
            if (!this.file.blockTableEntry.isSingleUnit() && curSectorSize > (long)this.sectorSize) {
                curSectorSize = this.sectorSize;
            }
            this.sectorReader = !this.file.blockTableEntry.isSingleUnit() ? new FileReader(this.file.mpqArchive.randomAccessFile, (long)this.file.mpqArchive.archiveOffset + this.file.blockTableEntry.getBlockOffset() + (long)this.sectorTable[this.readerSector]) : new FileReader(this.file.mpqArchive.randomAccessFile, (long)this.file.mpqArchive.archiveOffset + this.file.blockTableEntry.getBlockOffset() + (long)(this.readerSector * this.sectorSize));
            if (this.file.blockTableEntry.isEncrypted()) {
                throw new IOException("todo encryption");
            }
            if (!this.file.blockTableEntry.isCompressed()) throw new IOException();
            if ((long)compressedSectorSize >= curSectorSize) return;
            int compressionFlags = this.sectorReader.readInt8();
            if ((compressionFlags & 0x10) != 0) {
                this.sectorReader = new BZip2Reader(this.sectorReader, compressedSectorSize - 1);
            }
            if ((compressionFlags & 8) != 0) {
                throw new IOException("todo imploded");
            }
            if ((compressionFlags & 2) != 0) {
                this.sectorReader = new DeflateReader(this.sectorReader, compressedSectorSize - 1);
            }
            if ((compressionFlags & 1) != 0) {
                throw new IOException("todo huffman");
            }
            if ((compressionFlags & 0x80) != 0) {
                throw new IOException("ima adpcm stereo");
            }
            if ((compressionFlags & 0x40) != 0) {
                throw new IOException("ima adpcm mono");
            }
            if ((compressionFlags & 0x24) == 0) return;
            throw new IOException("unsupported compression " + String.format("%02x", compressionFlags));
        }
        this.sectorReader = new FileReader(this.file.mpqArchive.randomAccessFile, (long)this.file.mpqArchive.archiveOffset + this.file.blockTableEntry.getBlockOffset() + (long)(this.readerSector * this.sectorSize));
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.sectorReader != null) {
            this.sectorReader.close();
        }
        this.file = null;
        this.sectorReader = null;
    }
}

