/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.BlockTableEntry;
import com.threerings.resource.pack.HashTableEntry;
import com.threerings.resource.pack.MpqArchive;
import com.threerings.resource.pack.MpqInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MpqFile {
    final MpqArchive mpqArchive;
    final String filePath;
    final HashTableEntry hashTableEntry;
    final BlockTableEntry blockTableEntry;

    protected MpqFile(MpqArchive mpqArchive, String filePath, HashTableEntry hashTableEntry, BlockTableEntry blockTableEntry) {
        this.mpqArchive = mpqArchive;
        this.filePath = filePath;
        this.hashTableEntry = hashTableEntry;
        this.blockTableEntry = blockTableEntry;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getFileSize() {
        return (long)this.blockTableEntry.getFileSize() & 0xFFFFFFFFL;
    }

    public InputStream getInputStream() throws IOException {
        return new MpqInputStream(this);
    }

    public void extractTo(File file) throws IOException {
        InputStream inputStream = this.getInputStream();
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                int len;
                byte[] buffer = new byte[this.mpqArchive.getSectorSize()];
                while ((len = inputStream.read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, len);
                }
            }
            finally {
                ((OutputStream)outputStream).close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("File path: ").append(this.filePath).append('\n');
        s.append(this.hashTableEntry);
        s.append(this.blockTableEntry);
        return s.toString();
    }
}

