/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.BlockTableEntry;
import com.threerings.resource.pack.CryptWriter;
import com.threerings.resource.pack.DecryptReader;
import com.threerings.resource.pack.FileReader;
import com.threerings.resource.pack.FileWriter;
import com.threerings.resource.pack.HashTableEntry;
import com.threerings.resource.pack.MpqFile;
import com.threerings.resource.pack.MpqWriter;
import com.threerings.resource.pack.ReadMpqArchive;
import com.threerings.resource.pack.ReadWriteMpqArchive;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;

public strictfp class MpqArchive
implements ReadMpqArchive,
ReadWriteMpqArchive {
    private static final String MPQ_SIGNATURE = "MPQ\u001a";
    private final File file;
    int archiveOffset;
    private String signature;
    private int headerSize;
    private long archiveSize;
    private int formatVersion;
    int sectorSizeShift;
    private int unknown1;
    private long hashTableOffset;
    private long blockTableOffset;
    private int hashTableEntries;
    private int blockTableEntries;
    private long extBlockTableOffset;
    private Integer extAttrsVersion;
    private Integer extAttrsPresent;
    private final List<BlockTableEntry> blockTable = new ArrayList<BlockTableEntry>();
    private HashTableEntry[] hashTable;
    RandomAccessFile randomAccessFile;
    private final boolean rw;
    static final int[] cryptTable = new int[65535];

    static {
        int seed = 0x100001;
        int index1 = 0;
        while (index1 < 256) {
            int index2 = index1;
            int i = 0;
            while (i < 5) {
                seed = (seed * 125 + 3) % 0x2AAAAB;
                int temp1 = (seed & 0xFFFF) << 16;
                seed = (seed * 125 + 3) % 0x2AAAAB;
                int temp2 = seed & 0xFFFF;
                MpqArchive.cryptTable[index2] = temp1 | temp2;
                ++i;
                index2 += 256;
            }
            ++index1;
        }
    }

    public MpqArchive(File file) throws IOException {
        this(file, false);
    }

    public MpqArchive(File file, boolean rw) throws IOException {
        this.file = file;
        this.rw = rw;
        this.openAndRead();
    }

    public File getArchiveFile() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.randomAccessFile != null) {
            System.err.println("MpqArchive was not closed (finalizer)");
            this.close();
        }
    }

    private int hashString(String string, int hashType) {
        int seed1 = 2146271213;
        int seed2 = -286331154;
        string = string.toUpperCase();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            seed1 = cryptTable[hashType * 256 + ch] ^ seed1 + seed2;
            seed2 = ch + seed1 + seed2 + (seed2 << 5) + 3;
            ++i;
        }
        return seed1;
    }

    private void openAndRead() throws IOException {
        this.randomAccessFile = new RandomAccessFile(this.file, this.rw ? "rw" : "r");
        this.archiveOffset = 0;
        if (this.randomAccessFile.length() == 0L) {
            this.writeHeader();
        }
        this.findArchiveOffset();
        this.readHeader();
        this.readBlockTable();
        this.readHashTable();
    }

    int getSectorSize() {
        return 512 * (1 << this.sectorSizeShift);
    }

    private void writeHeader() throws IOException {
        this.checkReadWrite();
        if (this.signature == null) {
            this.signature = MPQ_SIGNATURE;
            this.headerSize = 44;
            this.archiveSize = 0L;
            this.formatVersion = 1;
            this.sectorSizeShift = 3;
            this.unknown1 = 0;
            this.hashTableOffset = 0L;
            this.blockTableOffset = 0L;
            this.hashTableEntries = 0;
            this.blockTableEntries = 0;
            this.extBlockTableOffset = 0L;
        }
        FileWriter fileWriter = new FileWriter(this.randomAccessFile, this.archiveOffset);
        fileWriter.writeChar4(this.signature);
        fileWriter.writeInt32(this.headerSize);
        fileWriter.writeInt32((int)this.archiveSize);
        fileWriter.writeInt16(this.formatVersion);
        fileWriter.writeInt8(this.sectorSizeShift);
        fileWriter.writeInt8(this.unknown1);
        fileWriter.writeInt32((int)this.hashTableOffset);
        fileWriter.writeInt32((int)this.blockTableOffset);
        fileWriter.writeInt32(this.hashTableEntries);
        fileWriter.writeInt32(this.blockTableEntries);
        if (this.formatVersion >= 1) {
            fileWriter.writeInt32((int)this.extBlockTableOffset);
            fileWriter.writeInt32((int)(this.extBlockTableOffset >>> 32));
            fileWriter.writeInt16((int)(this.hashTableOffset >>> 32));
            fileWriter.writeInt16((int)(this.blockTableOffset >>> 32));
        }
        fileWriter.close();
    }

    private void checkReadWrite() {
        if (!this.rw) {
            throw new IllegalStateException("read only");
        }
    }

    private void writeBlockTable() throws IOException {
        this.checkReadWrite();
        assert (this.blockTableEntries == this.blockTable.size());
        if (this.formatVersion >= 1 && this.extBlockTableOffset != 0L) {
            FileWriter extBlockTableWriter = new FileWriter(this.randomAccessFile, (long)this.archiveOffset + this.extBlockTableOffset);
            for (BlockTableEntry entry : this.blockTable) {
                extBlockTableWriter.writeInt16((int)(entry.getBlockOffset() >>> 32));
            }
        }
        FileWriter fileWriter = new FileWriter(this.randomAccessFile, (long)this.archiveOffset + this.blockTableOffset);
        CryptWriter blockTableWriter = new CryptWriter(fileWriter, this.blockTableEntries * 16, this.hashString("(block table)", 3));
        for (BlockTableEntry entry : this.blockTable) {
            blockTableWriter.writeInt32((int)entry.getBlockOffset());
            blockTableWriter.writeInt32(entry.getBlockSize());
            blockTableWriter.writeInt32(entry.getFileSize());
            blockTableWriter.writeInt32(entry.getFlags());
        }
    }

    private void writeHashTable() throws IOException {
        this.checkReadWrite();
        FileWriter fileWriter = new FileWriter(this.randomAccessFile, (long)this.archiveOffset + this.hashTableOffset);
        CryptWriter cryptWriter = new CryptWriter(fileWriter, this.hashTableEntries * 16, this.hashString("(hash table)", 3));
        int i = 0;
        while (i < this.hashTableEntries) {
            if (this.hashTable[i] == null) {
                this.hashTable[i] = new HashTableEntry(-1, -1, -1, -1, -1, -1);
            }
            cryptWriter.writeInt32(this.hashTable[i].getFilePathHashA());
            cryptWriter.writeInt32(this.hashTable[i].getFilePathHashB());
            cryptWriter.writeInt16(this.hashTable[i].getLanguage());
            cryptWriter.writeInt8(this.hashTable[i].getPlatform());
            cryptWriter.writeInt8(this.hashTable[i].getUnknown());
            cryptWriter.writeInt32(this.hashTable[i].getFileBlockIndex());
            ++i;
        }
    }

    @Override
    public void saveMetadata() throws IOException {
        this.checkReadWrite();
        this.writeAttributesFile();
        long maxBlockEnd = this.headerSize;
        boolean extBlockTableNeeded = false;
        for (BlockTableEntry blockTableEntry : this.blockTable) {
            long blockEnd = blockTableEntry.getBlockOffset() + (long)blockTableEntry.getBlockSize();
            if (blockEnd > maxBlockEnd) {
                maxBlockEnd = blockEnd;
            }
            if (blockTableEntry.getBlockOffset() <= 0xFFFFFFFFL) continue;
            extBlockTableNeeded = true;
        }
        if (maxBlockEnd > this.hashTableOffset) {
            this.hashTableOffset = maxBlockEnd;
        }
        this.hashTableEntries = this.hashTable.length;
        maxBlockEnd = this.hashTableOffset + (long)(this.hashTableEntries * 16);
        if (maxBlockEnd > this.blockTableOffset) {
            this.blockTableOffset = maxBlockEnd;
        }
        this.blockTableEntries = this.blockTable.size();
        maxBlockEnd = this.blockTableOffset + (long)(this.blockTableEntries * 16);
        if (extBlockTableNeeded) {
            if (maxBlockEnd > this.extBlockTableOffset) {
                this.extBlockTableOffset = maxBlockEnd;
            }
            maxBlockEnd = this.extBlockTableOffset + (long)(this.blockTableEntries * 2);
        } else {
            this.extBlockTableOffset = 0L;
        }
        this.archiveSize = maxBlockEnd;
        this.writeHeader();
        this.writeHashTable();
        this.writeBlockTable();
    }

    @Override
    public boolean isNew() {
        assert (this.hashTable.length == 0 == this.blockTable.isEmpty());
        return this.hashTable.length == 0;
    }

    @Override
    public void initHashtable(int size) {
        if (!this.isNew()) {
            throw new IllegalStateException();
        }
        if (Integer.bitCount(size) != 1) {
            throw new IllegalArgumentException("size must be (1<<x)");
        }
        this.hashTable = new HashTableEntry[size];
        this.hashTableEntries = size;
        this.blockTable.clear();
    }

    private void findArchiveOffset() throws IOException {
        int offset = 0;
        while ((long)offset < this.randomAccessFile.length()) {
            FileReader fileReader = new FileReader(this.randomAccessFile, offset);
            this.signature = fileReader.readChar4();
            if (!this.signature.equals(MPQ_SIGNATURE)) {
                offset += 1024;
                continue;
            }
            this.archiveOffset = offset;
            return;
        }
        throw new IOException("no valid MPQ signature found");
    }

    private void readHeader() throws IOException {
        FileReader fileReader = new FileReader(this.randomAccessFile, this.archiveOffset);
        this.signature = fileReader.readChar4();
        if (!this.signature.equals(MPQ_SIGNATURE)) {
            throw new IOException("no valid MPQ signature found");
        }
        this.headerSize = fileReader.readInt32();
        this.archiveSize = (long)fileReader.readInt32() & 0xFFFFFFFFL;
        this.formatVersion = fileReader.readInt16();
        this.sectorSizeShift = fileReader.readInt8();
        this.unknown1 = fileReader.readInt8();
        this.hashTableOffset = (long)fileReader.readInt32() & 0xFFFFFFFFL;
        this.blockTableOffset = (long)fileReader.readInt32() & 0xFFFFFFFFL;
        this.hashTableEntries = fileReader.readInt32();
        this.blockTableEntries = fileReader.readInt32();
        if (this.formatVersion >= 1) {
            this.extBlockTableOffset = (long)fileReader.readInt32() & 0xFFFFFFFFL;
            this.extBlockTableOffset |= ((long)fileReader.readInt32() & 0xFFFFFFFFL) << 32;
            this.hashTableOffset |= ((long)fileReader.readInt16() & 0xFFFFL) << 32;
            this.blockTableOffset |= ((long)fileReader.readInt16() & 0xFFFFL) << 32;
        }
        fileReader.close();
    }

    private void readBlockTable() throws IOException {
        this.blockTable.clear();
        int[] highOffsetBits = new int[this.blockTableEntries];
        if (this.formatVersion >= 1 && this.extBlockTableOffset != 0L) {
            FileReader extBlockTableReader = new FileReader(this.randomAccessFile, (long)this.archiveOffset + this.extBlockTableOffset);
            int i = 0;
            while (i < this.blockTableEntries) {
                highOffsetBits[i] = extBlockTableReader.readInt16() & 0xFFFF;
                ++i;
            }
        }
        FileReader fileReader = new FileReader(this.randomAccessFile, (long)this.archiveOffset + this.blockTableOffset);
        DecryptReader blockTableReader = new DecryptReader(fileReader, this.blockTableEntries * 16, this.hashString("(block table)", 3));
        int i = 0;
        while (i < this.blockTableEntries) {
            long blockOffset = (long)blockTableReader.readInt32() & 0xFFFFFFFFL;
            int blockSize = blockTableReader.readInt32();
            int fileSize = blockTableReader.readInt32();
            int flags = blockTableReader.readInt32();
            this.blockTable.add(new BlockTableEntry(blockOffset |= (long)highOffsetBits[i] << 32, blockSize, fileSize, flags));
            ++i;
        }
        assert (this.blockTableEntries == this.blockTable.size());
    }

    private void readHashTable() throws IOException {
        FileReader fileReader = new FileReader(this.randomAccessFile, (long)this.archiveOffset + this.hashTableOffset);
        DecryptReader decryptReader = new DecryptReader(fileReader, this.hashTableEntries * 16, this.hashString("(hash table)", 3));
        this.hashTable = new HashTableEntry[this.hashTableEntries];
        int i = 0;
        while (i < this.hashTableEntries) {
            int filePathHashA = decryptReader.readInt32();
            int filePathHashB = decryptReader.readInt32();
            int language = decryptReader.readInt16();
            int platform = decryptReader.readInt8();
            int unknown = decryptReader.readInt8();
            int fileBlockIndex = decryptReader.readInt32();
            this.hashTable[i] = new HashTableEntry(filePathHashA, filePathHashB, language, platform, unknown, fileBlockIndex);
            ++i;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("File: ").append(this.file).append('\n');
        s.append("Archive offset: ").append(this.archiveOffset).append('\n');
        s.append("Signature: ").append(this.signature).append('\n');
        s.append("Header size: ").append(this.headerSize).append('\n');
        s.append("Archive size: ").append(this.archiveSize).append('\n');
        s.append("Archive version: ").append(this.formatVersion).append('\n');
        s.append("Sector size shift: ").append(this.sectorSizeShift).append('\n');
        s.append("unknown1: ").append(this.unknown1).append('\n');
        s.append("Hash table offset: ").append(this.hashTableOffset).append('\n');
        s.append("Block table offset: ").append(this.blockTableOffset).append('\n');
        s.append("Hash table entries: ").append(this.hashTableEntries).append('\n');
        s.append("Block table entries: ").append(this.blockTableEntries).append('\n');
        if (this.formatVersion >= 1) {
            s.append("Extended block table offset: ").append(this.extBlockTableOffset).append('\n');
        }
        for (BlockTableEntry block : this.blockTable) {
            s.append(block.toString());
        }
        int i = 0;
        while (i < this.hashTable.length) {
            HashTableEntry hashTableEntry = this.hashTable[i];
            if (hashTableEntry.getFileBlockIndex() != -1) {
                s.append(hashTableEntry.toString());
            }
            ++i;
        }
        return s.toString();
    }

    private void checkClosed() {
        if (this.randomAccessFile == null) {
            throw new IllegalStateException("Archive is closed");
        }
    }

    @Override
    public MpqFile getFile(String filePath, Integer language, Integer platform) throws IOException {
        this.checkClosed();
        int initEntry = this.hashString(filePath, 0) & this.hashTableEntries - 1;
        HashTableEntry entry = this.hashTable[initEntry];
        if (entry == null || entry.getFileBlockIndex() == -1) {
            return null;
        }
        int hashA = this.hashString(filePath, 1);
        int hashB = this.hashString(filePath, 2);
        int curEntry = initEntry;
        do {
            if (entry == null || entry.getFileBlockIndex() == -2 || entry.getFilePathHashA() != hashA || entry.getFilePathHashB() != hashB || language != null && entry.getLanguage() != language.intValue() || platform != null && entry.getPlatform() != platform.intValue()) continue;
            entry.setFilePath(filePath);
            this.blockTable.get(entry.getFileBlockIndex()).setFilePath(filePath);
            return new MpqFile(this, filePath, entry, this.blockTable.get(entry.getFileBlockIndex()));
        } while ((entry = this.hashTable[curEntry = (curEntry + 1) % this.hashTableEntries]) != null && entry.getFileBlockIndex() != -1 && curEntry != initEntry);
        return null;
    }

    @Override
    public boolean deleteFile(String filePath, Integer language, Integer platform) {
        this.checkClosed();
        this.checkReadWrite();
        int initEntry = this.hashString(filePath, 0) & this.hashTableEntries - 1;
        HashTableEntry entry = this.hashTable[initEntry];
        if (entry == null || entry.getFileBlockIndex() == -1) {
            return false;
        }
        int hashA = this.hashString(filePath, 1);
        int hashB = this.hashString(filePath, 2);
        int curEntry = initEntry;
        boolean deletedSomething = false;
        do {
            if (entry == null || entry.getFileBlockIndex() == -2 || entry.getFilePathHashA() != hashA || entry.getFilePathHashB() != hashB || language != null && entry.getLanguage() != language.intValue() || platform != null && entry.getPlatform() != platform.intValue()) continue;
            int blockIndex = entry.getFileBlockIndex();
            this.blockTable.set(blockIndex, new BlockTableEntry(this.blockTable.get(blockIndex).getBlockOffset(), this.blockTable.get(blockIndex).getBlockSize(), 0, 0));
            int nextEntry = (curEntry + 1) % this.hashTableEntries;
            this.hashTable[curEntry] = this.hashTable[nextEntry].getFileBlockIndex() == -1 ? new HashTableEntry(0, 0, 0, 0, 0, -2) : new HashTableEntry(0, 0, 0, 0, 0, -1);
            deletedSomething = true;
        } while ((entry = this.hashTable[curEntry = (curEntry + 1) % this.hashTableEntries]) != null && entry.getFileBlockIndex() != -1 && curEntry != initEntry);
        return deletedSomething;
    }

    private int findFreeHashTableEntry(int fileHash) {
        int initEntry = fileHash & this.hashTableEntries - 1;
        HashTableEntry entry = this.hashTable[initEntry];
        int curEntry = initEntry;
        do {
            if (entry == null || entry.getFileBlockIndex() == -1 || entry.getFileBlockIndex() == -2) {
                return curEntry;
            }
            curEntry = (curEntry + 1) % this.hashTableEntries;
            entry = this.hashTable[curEntry];
        } while (curEntry != initEntry);
        return -1;
    }

    @Override
    public boolean addFile(File newFile, String filePath, int language, int platform) throws IOException {
        this.checkClosed();
        this.checkReadWrite();
        long fileSize = newFile.length();
        FileInputStream fileInputStream = new FileInputStream(newFile);
        try {
            boolean bl = this.addFile(filePath, language, platform, fileInputStream, fileSize);
            return bl;
        }
        finally {
            fileInputStream.close();
        }
    }

    @Override
    public boolean addFile(String filePath, int language, int platform, InputStream inputStream, long fileSize) throws IOException {
        long maxBlockEnd = this.headerSize;
        for (BlockTableEntry blockTableEntry : this.blockTable) {
            long blockEnd = blockTableEntry.getBlockOffset() + (long)blockTableEntry.getBlockSize();
            if (blockEnd <= maxBlockEnd) continue;
            maxBlockEnd = blockEnd;
        }
        int hashTableEntry = this.findFreeHashTableEntry(this.hashString(filePath, 0));
        if (hashTableEntry < 0) {
            return false;
        }
        int hashA = this.hashString(filePath, 1);
        int hashB = this.hashString(filePath, 2);
        MpqWriter mpqWriter = new MpqWriter(this, maxBlockEnd, fileSize);
        int sectorSize = this.getSectorSize();
        int i = 0;
        while ((long)i < (fileSize + (long)sectorSize - 1L) / (long)sectorSize) {
            long remaining = fileSize - (long)(i * sectorSize);
            byte[] data = new byte[(int)(remaining > (long)sectorSize ? (long)sectorSize : remaining)];
            int datalen = inputStream.read(data);
            if (datalen != data.length) {
                throw new IOException("couldn't read input file");
            }
            mpqWriter.writeSector(data);
            ++i;
        }
        BlockTableEntry blockTableEntry = mpqWriter.getBlockTableEntry();
        blockTableEntry.setFilePath(filePath);
        this.blockTable.add(blockTableEntry);
        HashTableEntry entry = new HashTableEntry(hashA, hashB, language, platform, 0, this.blockTable.indexOf(blockTableEntry));
        entry.setFilePath(filePath);
        this.hashTable[hashTableEntry] = entry;
        return true;
    }

    private boolean writeAttributesFile() throws IOException {
        int i;
        this.checkClosed();
        this.checkReadWrite();
        String filePath = "(attributes)";
        this.deleteFile(filePath, null, null);
        if (this.extAttrsVersion == null) {
            this.extAttrsVersion = 100;
            this.extAttrsPresent = 7;
        }
        int blocks = this.blockTable.size() + 1;
        int size = 8;
        int attrsPresent = this.extAttrsPresent;
        if ((attrsPresent & 1) != 0) {
            size += blocks * 4;
        }
        if ((attrsPresent & 2) != 0) {
            size += blocks * 8;
        }
        if ((attrsPresent & 4) != 0) {
            size += blocks * 16;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.extAttrsVersion);
        buffer.putInt(this.extAttrsPresent);
        if ((attrsPresent & 1) != 0) {
            i = 0;
            while (i < blocks) {
                Integer v;
                int crc32 = i < this.blockTable.size() ? ((v = this.blockTable.get(i).getExtCRC32()) == null ? 0 : v) : 0;
                buffer.putInt(crc32);
                ++i;
            }
        }
        if ((attrsPresent & 2) != 0) {
            i = 0;
            while (i < blocks) {
                Long v;
                long filetime = i < this.blockTable.size() ? ((v = this.blockTable.get(i).getExtFiletime()) == null ? 0L : v) : 0L;
                buffer.putLong(filetime);
                ++i;
            }
        }
        if ((attrsPresent & 4) != 0) {
            i = 0;
            while (i < blocks) {
                byte[] md5 = null;
                if (i < this.blockTable.size()) {
                    md5 = this.blockTable.get(i).getExtMD5();
                }
                if (md5 == null) {
                    md5 = new byte[16];
                }
                byte[] byArray = md5;
                int n = md5.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    buffer.put(b);
                    ++n2;
                }
                ++i;
            }
        }
        assert (buffer.position() == buffer.limit());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.array(), buffer.arrayOffset(), size);
        return this.addFile(filePath, 0, 0, inputStream, size);
    }

    private static int isReadInt32(InputStream is) throws IOException {
        int c1 = is.read();
        int c2 = is.read();
        int c3 = is.read();
        int c4 = is.read();
        if (c4 == -1) {
            throw new EOFException();
        }
        return c1 + c2 * 256 + c3 * 256 * 256 + c4 * 256 * 256 * 256;
    }

    @Override
    public void readExtData() throws IOException {
        MpqFile listFile;
        this.checkClosed();
        MpqFile attrFile = this.getFile("(attributes)", 0, 0);
        if (attrFile != null) {
            InputStream inputStream = attrFile.getInputStream();
            try {
                int i;
                int version = MpqArchive.isReadInt32(inputStream);
                this.extAttrsVersion = version;
                int attrsPresent = MpqArchive.isReadInt32(inputStream);
                this.extAttrsPresent = attrsPresent;
                if ((attrsPresent & 1) != 0) {
                    i = 0;
                    while (i < this.blockTableEntries) {
                        int crc32 = MpqArchive.isReadInt32(inputStream);
                        this.blockTable.get(i).setExtCRC32(crc32);
                        ++i;
                    }
                }
                if ((attrsPresent & 2) != 0) {
                    i = 0;
                    while (i < this.blockTableEntries) {
                        int lowTime = MpqArchive.isReadInt32(inputStream);
                        int highTime = MpqArchive.isReadInt32(inputStream);
                        long extFiletime = (long)lowTime & 0xFFFFFFFFL | ((long)highTime & 0xFFFFFFFFL) << 32;
                        this.blockTable.get(i).setExtFiletime(extFiletime);
                        ++i;
                    }
                }
                if ((attrsPresent & 4) != 0) {
                    i = 0;
                    while (i < this.blockTableEntries) {
                        byte[] md5 = new byte[16];
                        int j = 0;
                        while (j < 16) {
                            int b = inputStream.read();
                            if (b == -1) {
                                throw new EOFException();
                            }
                            md5[j] = (byte)b;
                            ++j;
                        }
                        this.blockTable.get(i).setExtMD5(md5);
                        ++i;
                    }
                }
            }
            finally {
                inputStream.close();
            }
        }
        if ((listFile = this.getFile("(listfile)", 0, 0)) != null) {
            InputStream inputStream = listFile.getInputStream();
            try {
                Scanner scan = new Scanner(inputStream, "UTF-8");
                scan.useDelimiter(Pattern.compile("[;\\r\\n]+"));
                while (scan.hasNext()) {
                    String name = scan.next();
                    this.getFile(name, null, null);
                }
                scan.close();
            }
            finally {
                inputStream.close();
            }
        }
    }

    @Override
    public Collection<String> listFileNames() {
        ArrayList<String> names = new ArrayList<String>();
        HashTableEntry[] hashTableEntryArray = this.hashTable;
        int n = this.hashTable.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            HashTableEntry entry = hashTableEntryArray[n2];
            if (entry != null && entry.getFileBlockIndex() != -1 && entry.getFileBlockIndex() != -2 && (name = entry.getFilePath()) != null) {
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    public void dump(PrintStream out) {
        StringBuilder s = new StringBuilder();
        s.append("File: ").append(this.file).append('\n');
        s.append("Archive offset: ").append(this.archiveOffset).append('\n');
        s.append("Signature: ").append(this.signature).append('\n');
        s.append("Header size: ").append(this.headerSize).append('\n');
        s.append("Archive size: ").append(this.archiveSize).append('\n');
        s.append("Archive version: ").append(this.formatVersion).append('\n');
        s.append("Sector size shift: ").append(this.sectorSizeShift).append('\n');
        s.append("unknown1: ").append(this.unknown1).append('\n');
        s.append("Hash table offset: ").append(this.hashTableOffset).append('\n');
        s.append("Block table offset: ").append(this.blockTableOffset).append('\n');
        s.append("Hash table entries: ").append(this.hashTableEntries).append('\n');
        s.append("Block table entries: ").append(this.blockTableEntries).append('\n');
        if (this.formatVersion >= 1) {
            s.append("Extended block table offset: ").append(this.extBlockTableOffset).append('\n');
        }
        out.print(s);
        for (BlockTableEntry block : this.blockTable) {
            out.print(block.toString());
        }
        int i = 0;
        while (i < this.hashTable.length) {
            HashTableEntry hashTableEntry = this.hashTable[i];
            if (hashTableEntry.getFileBlockIndex() != -1) {
                out.print(hashTableEntry.toString());
            }
            ++i;
        }
    }
}

