/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.Writer;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileWriter
extends Writer {
    private final RandomAccessFile file;
    private long writerPosition;

    public FileWriter(RandomAccessFile file) throws IOException {
        this.file = file;
        this.writerPosition = file.getFilePointer();
    }

    public FileWriter(RandomAccessFile file, long position) throws IOException {
        this.file = file;
        this.writerPosition = position;
        file.seek(position);
    }

    @Override
    protected void writeByte(int v) throws IOException {
        this.file.write(v);
        ++this.writerPosition;
    }

    @Override
    public void writeBlock(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.file.write(b, off, len);
        this.writerPosition += (long)len;
    }

    @Override
    public void seek(long position) throws IOException {
        this.writerPosition = position;
        this.file.seek(position);
    }
}

