/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.Reader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileReader
extends Reader {
    private final RandomAccessFile file;
    private static final int defaultBufferLength = 8192;
    private long bufferStartPosition;
    private int bufferDataLength;
    private int bufferLength;
    private byte[] buffer;
    private long readerPosition;

    public FileReader(RandomAccessFile file) throws IOException {
        this.file = file;
        this.readerPosition = file.getFilePointer();
    }

    public FileReader(RandomAccessFile file, long position) throws IOException {
        this.file = file;
        this.readerPosition = position;
        file.seek(position);
    }

    @Override
    protected int readByte() throws IOException {
        if (this.buffer == null) {
            this.startBuffer();
        }
        if (this.readerPosition < this.bufferStartPosition) {
            this.readBuffer();
        }
        if (this.readerPosition >= this.bufferStartPosition + (long)this.bufferDataLength) {
            if (this.readerPosition >= this.file.length()) {
                return -1;
            }
            this.readBuffer();
        }
        int bufferIndex = (int)(this.readerPosition - this.bufferStartPosition);
        byte b = this.buffer[bufferIndex];
        ++this.readerPosition;
        return b & 0xFF;
    }

    @Override
    public int readBlock(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.buffer == null) {
            this.startBuffer();
        }
        if (this.readerPosition < this.bufferStartPosition) {
            this.readBuffer();
        }
        int bytesRead = 0;
        while (bytesRead < len) {
            int remaining;
            int bufferIndex;
            int bytesAvailable;
            if (this.readerPosition >= this.bufferStartPosition + (long)this.bufferDataLength) {
                if (this.readerPosition >= this.file.length()) {
                    return bytesRead == 0 ? -1 : bytesRead;
                }
                this.readBuffer();
            }
            int toRead = (bytesAvailable = this.bufferDataLength - (bufferIndex = (int)(this.readerPosition - this.bufferStartPosition))) < (remaining = len - bytesRead) ? bytesAvailable : remaining;
            System.arraycopy(this.buffer, bufferIndex, b, off + bytesRead, toRead);
            this.readerPosition += (long)toRead;
            bytesRead += toRead;
        }
        return bytesRead;
    }

    private void startBuffer() throws IOException {
        this.bufferLength = 8192;
        this.buffer = new byte[this.bufferLength];
        this.readBuffer();
    }

    private void readBuffer() throws IOException {
        this.bufferStartPosition = this.readerPosition;
        this.file.seek(this.bufferStartPosition);
        this.bufferDataLength = this.file.read(this.buffer);
    }

    @Override
    public void seek(long position) throws IOException {
        this.readerPosition = position;
    }
}

