/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.MpqArchive;
import com.threerings.resource.pack.Reader;
import java.io.IOException;

class DecryptReader
extends Reader {
    private Reader reader;
    private long length;
    private int key;
    private int seed;
    private int decrypted;
    private int decryptedBytesLeft;
    static final int[] cryptTable = MpqArchive.cryptTable;

    public DecryptReader(Reader reader, long length, int key) {
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        if (cryptTable == null) {
            throw new NullPointerException("cryptTable");
        }
        if ((length & 3L) != 0L) {
            throw new IllegalArgumentException("length");
        }
        this.reader = reader;
        this.length = length;
        this.key = key;
        this.seed = -286331154;
    }

    @Override
    protected int readByte() throws IOException {
        if (this.decryptedBytesLeft == 0) {
            if (this.length <= 0L) {
                return -1;
            }
            this.seed += cryptTable[1024 + (this.key & 0xFF)];
            this.decrypted = this.reader.readInt32() ^ this.key + this.seed;
            this.key = (~this.key << 21) + 0x11111111 | this.key >>> 11;
            this.seed = this.decrypted + this.seed + (this.seed << 5) + 3;
            this.decryptedBytesLeft = 4;
            this.length -= 4L;
        }
        int b = this.decrypted & 0xFF;
        this.decrypted >>>= 8;
        --this.decryptedBytesLeft;
        return b;
    }

    @Override
    public void seek(long position) throws IOException {
        this.reader.seek(position);
    }
}

