/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.MpqArchive;
import com.threerings.resource.pack.Writer;
import java.io.EOFException;
import java.io.IOException;

class CryptWriter
extends Writer {
    private Writer writer;
    private long length;
    private int key;
    private int seed;
    private int bytes;
    private int byteCount;
    static final int[] cryptTable = MpqArchive.cryptTable;

    public CryptWriter(Writer writer, long length, int key) {
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        if ((length & 3L) != 0L) {
            throw new IllegalArgumentException("length");
        }
        this.writer = writer;
        this.length = length;
        this.key = key;
        this.seed = -286331154;
    }

    @Override
    protected void writeByte(int v) throws IOException {
        if (this.length <= 0L) {
            throw new EOFException();
        }
        this.bytes |= (v & 0xFF) << this.byteCount * 8;
        ++this.byteCount;
        if (this.byteCount == 4) {
            this.seed += cryptTable[1024 + (this.key & 0xFF)];
            this.writer.writeInt32(this.bytes ^ this.key + this.seed);
            this.key = (~this.key << 21) + 0x11111111 | this.key >>> 11;
            this.seed = this.bytes + this.seed + (this.seed << 5) + 3;
            this.byteCount = 0;
            this.length -= 4L;
            this.bytes = 0;
        }
    }

    @Override
    public void seek(long position) throws IOException {
        this.writer.seek(position);
    }
}

