/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

class BlockTableEntry {
    private long blockOffset;
    private int blockSize;
    private int fileSize;
    private int flags;
    private String filePath;
    private Integer extCRC32;
    private Long extFiletime;
    private byte[] extMD5;

    public BlockTableEntry(long blockOffset, int blockSize, int fileSize, int flags) {
        this.blockOffset = blockOffset;
        this.blockSize = blockSize;
        this.fileSize = fileSize;
        this.flags = flags;
    }

    public long getBlockOffset() {
        return this.blockOffset;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isFile() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public boolean isSingleUnit() {
        return (this.flags & 0x1000000) != 0;
    }

    public boolean isEncryptionAdjusted() {
        return (this.flags & 0x20000) != 0;
    }

    public boolean isEncrypted() {
        return (this.flags & 0x10000) != 0;
    }

    public boolean isCompressed() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isImploded() {
        return (this.flags & 0x100) != 0;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Integer getExtCRC32() {
        return this.extCRC32;
    }

    public void setExtCRC32(Integer extCRC32) {
        this.extCRC32 = extCRC32;
    }

    public Long getExtFiletime() {
        return this.extFiletime;
    }

    public void setExtFiletime(Long extFiletime) {
        this.extFiletime = extFiletime;
    }

    public byte[] getExtMD5() {
        return this.extMD5;
    }

    public void setExtMD5(byte[] extMD5) {
        if (extMD5 != null && extMD5.length != 16) {
            throw new IllegalArgumentException("extMD5");
        }
        this.extMD5 = extMD5;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('\n');
        s.append("Block offset: ").append(this.blockOffset).append('\n');
        s.append("Block size: ").append(this.blockSize).append('\n');
        s.append("File size: ").append(this.fileSize).append('\n');
        s.append("Flags: ").append(String.format("%08x", this.flags)).append('\n');
        s.append("File path: ").append(this.filePath).append('\n');
        if (this.extCRC32 != null) {
            s.append("CRC32: ").append(this.extCRC32).append('\n');
        }
        if (this.extFiletime != null) {
            s.append("File time: ").append(this.extFiletime).append('\n');
        }
        if (this.extMD5 != null) {
            s.append("MD5:");
            byte[] byArray = this.extMD5;
            int n = this.extMD5.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                s.append(String.format(" %02x", b & 0xFF));
                ++n2;
            }
            s.append('\n');
        }
        return s.toString();
    }
}

