/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.pack;

import com.threerings.resource.pack.Reader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.bzip2.CBZip2InputStream;

class BZip2Reader
extends Reader {
    private CBZip2InputStream is;

    public BZip2Reader(final Reader reader, int compressedLength) throws IOException {
        int cB = reader.readInt8();
        int cZ = reader.readInt8();
        if (cB != 66 || cZ != 90) {
            throw new IOException("No BZip2 stream found");
        }
        this.is = new CBZip2InputStream(new InputStream(compressedLength){
            int remaining;
            {
                this.remaining = n - 2;
            }

            @Override
            public int read() throws IOException {
                if (this.remaining <= 0) {
                    return -1;
                }
                try {
                    --this.remaining;
                    return reader.readInt8();
                }
                catch (EOFException e) {
                    return -1;
                }
            }
        });
    }

    @Override
    protected int readByte() throws IOException {
        if (this.is == null) {
            return -1;
        }
        int c = this.is.read();
        if (c == -1) {
            this.close();
        }
        return c;
    }

    @Override
    public void seek(long position) throws IOException {
        throw new IOException("Cannot seek in a compressed stream");
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
    }
}

