/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.threerings.media.Log;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class BackgroundTiler {
    protected BufferedImage[] _tiles;
    protected int _w3;
    protected int _h3;
    protected int _cw3;
    protected int _ch3;

    public BackgroundTiler(BufferedImage src) {
        if (src == null) {
            Log.log.info((Object)"Backgrounder given null source image. Coping.", new Object[0]);
            return;
        }
        int width = src.getWidth(null);
        int height = src.getHeight(null);
        this._w3 = width / 3;
        this._cw3 = width - 2 * this._w3;
        this._h3 = height / 3;
        this._ch3 = height - 2 * this._h3;
        if (this._w3 <= 0 || this._cw3 <= 0 || this._h3 <= 0 || this._ch3 <= 0) {
            Log.log.warning((Object)"Backgrounder given source image of insufficient size for tiling", new Object[]{"width", width, "height", height});
            return;
        }
        this._tiles = new BufferedImage[9];
        int[] nArray = new int[3];
        nArray[1] = this._h3;
        nArray[2] = this._h3 + this._ch3;
        int[] sy = nArray;
        int[] thei = new int[]{this._h3, this._ch3, this._h3};
        int ii = 0;
        while (ii < 3) {
            this._tiles[3 * ii] = src.getSubimage(0, sy[ii], this._w3, thei[ii]);
            this._tiles[3 * ii + 1] = src.getSubimage(this._w3, sy[ii], this._cw3, thei[ii]);
            this._tiles[3 * ii + 2] = src.getSubimage(width - this._w3, sy[ii], this._w3, thei[ii]);
            ++ii;
        }
    }

    public int getNaturalWidth() {
        return this._w3 * 2 + this._cw3;
    }

    public int getNaturalHeight() {
        return this._h3 * 2 + this._ch3;
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        if (this._tiles == null) {
            return;
        }
        int rwid = width - 2 * this._w3;
        int rhei = height - 2 * this._h3;
        g.drawImage(this._tiles[0], x, y, this._w3, this._h3, null);
        g.drawImage(this._tiles[1], x + this._w3, y, rwid, this._h3, null);
        g.drawImage(this._tiles[2], x + this._w3 + rwid, y, this._w3, this._h3, null);
        g.drawImage(this._tiles[3], x, y += this._h3, this._w3, rhei, null);
        g.drawImage(this._tiles[4], x + this._w3, y, rwid, rhei, null);
        g.drawImage(this._tiles[5], x + this._w3 + rwid, y, this._w3, rhei, null);
        g.drawImage(this._tiles[6], x, y += rhei, this._w3, this._h3, null);
        g.drawImage(this._tiles[7], x + this._w3, y, rwid, this._h3, null);
        g.drawImage(this._tiles[8], x + this._w3 + rwid, y, this._w3, this._h3, null);
    }
}

