/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sprite;

import com.google.common.base.Predicate;
import com.samskivert.util.SortableArrayList;
import com.threerings.media.AbstractMedia;
import com.threerings.media.AbstractMediaManager;
import com.threerings.media.sprite.Sprite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SpriteManager
extends AbstractMediaManager {
    protected SortableArrayList<Sprite> _sprites;

    public void getIntersectingSprites(List<Sprite> list, Shape shape) {
        int size = this._sprites.size();
        int ii = 0;
        while (ii < size) {
            Sprite sprite = (Sprite)this._sprites.get(ii);
            if (sprite.intersects(shape)) {
                list.add(sprite);
            }
            ++ii;
        }
    }

    public void getHitSprites(List<Sprite> list, int x, int y) {
        int ii = this._sprites.size() - 1;
        while (ii >= 0) {
            Sprite sprite = (Sprite)this._sprites.get(ii);
            if (sprite.hitTest(x, y)) {
                list.add(sprite);
            }
            --ii;
        }
    }

    public Sprite getHighestHitSprite(int x, int y) {
        int ii = this._sprites.size() - 1;
        while (ii >= 0) {
            Sprite sprite = (Sprite)this._sprites.get(ii);
            if (sprite.hitTest(x, y)) {
                return sprite;
            }
            --ii;
        }
        return null;
    }

    public void addSprite(Sprite sprite) {
        if (this.insertMedia(sprite)) {
            sprite.invalidate();
        }
    }

    public List<Sprite> getSprites() {
        return Collections.unmodifiableList(this._sprites);
    }

    public Iterator<Sprite> enumerateSprites() {
        return this._sprites.iterator();
    }

    public void removeSprite(Sprite sprite) {
        this.removeMedia(sprite);
    }

    public void removeSprites(Predicate<Sprite> pred) {
        int idxoff = 0;
        int ii = 0;
        int ll = this._sprites.size();
        while (ii < ll) {
            Sprite sprite = (Sprite)this._sprites.get(ii - idxoff);
            if (pred.apply((Object)sprite)) {
                this._sprites.remove((Object)sprite);
                sprite.invalidate();
                sprite.shutdown();
                ++idxoff;
                if (ii <= this._tickpos) {
                    --this._tickpos;
                }
            }
            ++ii;
        }
    }

    public void renderSpritePaths(Graphics2D gfx) {
        for (Sprite sprite : this._sprites) {
            sprite.paintPath(gfx);
        }
    }

    @Override
    protected SortableArrayList<? extends AbstractMedia> createMediaList() {
        this._sprites = new SortableArrayList();
        return this._sprites;
    }
}

