/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.google.common.collect.Lists;
import com.samskivert.swing.Controller;
import com.samskivert.swing.event.AncestorAdapter;
import com.samskivert.swing.event.CommandEvent;
import com.threerings.media.FrameManager;
import com.threerings.media.FrameParticipant;
import com.threerings.media.Log;
import com.threerings.media.MediaConstants;
import com.threerings.media.MediaHost;
import com.threerings.media.MetaMediaManager;
import com.threerings.media.RegionManager;
import com.threerings.media.animation.Animation;
import com.threerings.media.animation.AnimationManager;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.sprite.SpriteManager;
import com.threerings.media.sprite.action.ActionSprite;
import com.threerings.media.sprite.action.ArmingSprite;
import com.threerings.media.sprite.action.CommandSprite;
import com.threerings.media.sprite.action.DisableableSprite;
import com.threerings.media.sprite.action.HoverSprite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;

public class MediaPanel
extends JComponent
implements FrameParticipant,
MediaConstants,
MediaHost {
    protected MetaMediaManager _metamgr;
    protected AnimationManager _animmgr;
    protected SpriteManager _spritemgr;
    protected RegionManager _remgr;
    protected boolean _tickPaintPending = false;
    protected ActionSpriteHandler _actionHandler;
    protected int _actionSpriteCount;
    protected ArrayList<Obscurer> _obscurerList;

    public MediaPanel(FrameManager framemgr) {
        this.setOpaque(true);
        this._metamgr = new MetaMediaManager(framemgr, this);
        this._animmgr = this._metamgr.getAnimationManager();
        this._spritemgr = this._metamgr.getSpriteManager();
        this._remgr = this._metamgr.getRegionManager();
        this.addAncestorListener((AncestorListener)new AncestorAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                MediaPanel.this._metamgr.getFrameManager().registerFrameParticipant(MediaPanel.this);
            }

            public void ancestorRemoved(AncestorEvent event) {
                MediaPanel.this._metamgr.getFrameManager().removeFrameParticipant(MediaPanel.this);
            }
        });
    }

    public Rectangle getViewBounds() {
        return new Rectangle(this.getWidth(), this.getHeight());
    }

    public AnimationManager getAnimationManager() {
        return this._metamgr.getAnimationManager();
    }

    public SpriteManager getSpriteManager() {
        return this._metamgr.getSpriteManager();
    }

    public RegionManager getRegionManager() {
        return this._metamgr.getRegionManager();
    }

    public void setPaused(boolean paused) {
        this._metamgr.setPaused(paused);
    }

    public long getTimeStamp() {
        return this._metamgr.getTimeStamp();
    }

    public void addSprite(Sprite sprite) {
        this._metamgr.addSprite(sprite);
        if ((sprite instanceof ActionSprite || sprite instanceof HoverSprite) && this._actionSpriteCount++ == 0) {
            if (this._actionHandler == null) {
                this._actionHandler = this.createActionSpriteHandler();
            }
            this.addMouseListener(this._actionHandler);
            this.addMouseMotionListener(this._actionHandler);
        }
    }

    public boolean isManaged(Sprite sprite) {
        return this._metamgr.isManaged(sprite);
    }

    public void removeSprite(Sprite sprite) {
        this._metamgr.removeSprite(sprite);
        if ((sprite instanceof ActionSprite || sprite instanceof HoverSprite) && --this._actionSpriteCount == 0) {
            this.removeMouseListener(this._actionHandler);
            this.removeMouseMotionListener(this._actionHandler);
        }
    }

    public void clearSprites() {
        this._metamgr.clearSprites();
        if (this._actionHandler != null) {
            this.removeMouseListener(this._actionHandler);
            this.removeMouseMotionListener(this._actionHandler);
            this._actionSpriteCount = 0;
        }
    }

    public void addAnimation(Animation anim) {
        this._metamgr.addAnimation(anim);
    }

    public boolean isManaged(Animation anim) {
        return this._metamgr.isManaged(anim);
    }

    public void abortAnimation(Animation anim) {
        this._metamgr.abortAnimation(anim);
    }

    public void clearAnimations() {
        this._metamgr.clearAnimations();
    }

    @Override
    public Graphics2D createGraphics() {
        return (Graphics2D)this.getGraphics();
    }

    @Override
    public void tick(long tickStamp) {
        if (this._metamgr.isPaused()) {
            return;
        }
        this.willTick(tickStamp);
        this._metamgr.tick(tickStamp);
        this.didTick(tickStamp);
        this._tickPaintPending = true;
    }

    @Override
    public boolean needsPaint() {
        boolean needsPaint = this._metamgr.needsPaint();
        if (!needsPaint) {
            this._tickPaintPending = false;
        }
        return needsPaint;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setOpaque(boolean opaque) {
        if (!opaque) {
            Log.log.warning((Object)"Media panels shouldn't be setOpaque(false).", new Object[]{new Exception()});
        }
        super.setOpaque(true);
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (width > 0 && height > 0) {
            this.dirtyScreenRect(new Rectangle(x, y, width, height));
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D gfx = (Graphics2D)g;
        if (!this.isValid() || !this.isShowing()) {
            return;
        }
        if (!this._tickPaintPending) {
            Shape clip = g.getClip();
            if (clip == null) {
                this.repaint();
            } else {
                this.dirtyScreenRect(clip.getBounds());
            }
        } else {
            this._tickPaintPending = false;
        }
        this.addObscurerDirtyRegions(true);
        if (!this._metamgr.getRegionManager().haveDirtyRegions()) {
            return;
        }
        Rectangle[] dirty = this._metamgr.getRegionManager().getDirtyRegions();
        this._metamgr.noteDirty(dirty.length);
        try {
            this.paint(gfx, dirty);
        }
        catch (Throwable t) {
            Log.log.warning((Object)(this + " choked in paint(" + dirty + ")."), new Object[]{t});
        }
        this._metamgr.paintPerf(gfx);
    }

    public void addObscurer(Obscurer obscurer) {
        if (this._obscurerList == null) {
            this._obscurerList = Lists.newArrayList();
        }
        this._obscurerList.add(obscurer);
    }

    public void removeObscurer(Obscurer obscurer) {
        if (this._obscurerList != null) {
            this._obscurerList.remove(obscurer);
        }
    }

    protected void addObscurerDirtyRegions(boolean changedOnly) {
        if (this._obscurerList != null) {
            for (Obscurer obscurer : this._obscurerList) {
                Rectangle obscured = obscurer.getObscured(changedOnly);
                if (obscured == null) continue;
                Point pt = new Point(obscured.x, obscured.y);
                SwingUtilities.convertPointFromScreen(pt, this);
                this.addObscurerDirtyRegion(new Rectangle(pt.x, pt.y, obscured.width, obscured.height));
            }
        }
    }

    protected void addObscurerDirtyRegion(Rectangle region) {
        this.dirtyScreenRect(region);
    }

    protected void willTick(long tickStamp) {
    }

    protected void didTick(long tickStamp) {
    }

    protected void paint(Graphics2D gfx, Rectangle[] dirty) {
        int dcount = dirty.length;
        int ii = 0;
        while (ii < dcount) {
            Rectangle clip = dirty[ii];
            if (clip == null) {
                Log.log.warning((Object)"Found null dirty rect painting media panel?!", new Object[]{new Exception()});
            } else {
                this.constrainToBounds(clip);
                if (clip.width != 0 && clip.height != 0) {
                    this.clipToDirtyRegion(gfx, clip);
                    this.paintDirtyRect(gfx, clip);
                }
            }
            ++ii;
        }
    }

    protected void paintDirtyRect(Graphics2D gfx, Rectangle rect) {
        this.paintBehind(gfx, rect);
        this.paintBits(gfx, 1, rect);
        this.paintBetween(gfx, rect);
        this.paintBits(gfx, 2, rect);
        this.paintInFront(gfx, rect);
    }

    protected void constrainToBounds(Rectangle dirty) {
        SwingUtilities.computeIntersection(0, 0, this.getWidth(), this.getHeight(), dirty);
    }

    protected void clipToDirtyRegion(Graphics2D gfx, Rectangle dirty) {
        gfx.setClip(dirty);
    }

    protected void dirtyScreenRect(Rectangle rect) {
        this._metamgr.getRegionManager().addDirtyRegion(rect);
    }

    protected void paintBehind(Graphics2D gfx, Rectangle dirtyRect) {
    }

    protected void paintBetween(Graphics2D gfx, Rectangle dirtyRect) {
    }

    protected void paintInFront(Graphics2D gfx, Rectangle dirtyRect) {
    }

    protected void paintBits(Graphics2D gfx, int layer, Rectangle dirty) {
        this._metamgr.paintMedia(gfx, layer, dirty);
    }

    protected ActionSpriteHandler createActionSpriteHandler() {
        return new ActionSpriteHandler();
    }

    protected class ActionSpriteHandler
    extends MouseInputAdapter {
        protected Sprite _activeSprite;

        protected ActionSpriteHandler() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Sprite s;
            if (this._activeSprite == null && (s = this.getHit(me)) instanceof ActionSprite) {
                this._activeSprite = s;
            }
            if (this._activeSprite instanceof ArmingSprite) {
                ((ArmingSprite)((Object)this._activeSprite)).setArmed(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (this._activeSprite instanceof ArmingSprite) {
                ((ArmingSprite)((Object)this._activeSprite)).setArmed(false);
            }
            if (this._activeSprite instanceof ActionSprite && this._activeSprite.hitTest(me.getX(), me.getY())) {
                ActionEvent event;
                if (this._activeSprite instanceof CommandSprite) {
                    CommandSprite cs = (CommandSprite)((Object)this._activeSprite);
                    event = new CommandEvent((Object)MediaPanel.this, cs.getActionCommand(), cs.getCommandArgument(), me.getWhen(), me.getModifiers());
                } else {
                    ActionSprite as = (ActionSprite)((Object)this._activeSprite);
                    event = new ActionEvent(MediaPanel.this, 1001, as.getActionCommand(), me.getWhen(), me.getModifiers());
                }
                Controller.postAction((ActionEvent)event);
            }
            if (!(this._activeSprite instanceof HoverSprite)) {
                this._activeSprite = null;
            }
            this.mouseMoved(me);
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (this._activeSprite instanceof ArmingSprite) {
                ((ArmingSprite)((Object)this._activeSprite)).setArmed(this._activeSprite.hitTest(me.getX(), me.getY()));
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            Sprite s = this.getHit(me);
            if (this._activeSprite == s) {
                return;
            }
            if (this._activeSprite instanceof HoverSprite) {
                ((HoverSprite)((Object)this._activeSprite)).setHovered(false);
            }
            this._activeSprite = s;
            if (this._activeSprite instanceof HoverSprite) {
                ((HoverSprite)((Object)this._activeSprite)).setHovered(true);
            }
        }

        protected Sprite getHit(MouseEvent me) {
            ArrayList list = Lists.newArrayList();
            MediaPanel.this.getSpriteManager().getHitSprites(list, me.getX(), me.getY());
            int ii = 0;
            int nn = list.size();
            while (ii < nn) {
                Object o = list.get(ii);
                if ((o instanceof HoverSprite || o instanceof ActionSprite) && (!(o instanceof DisableableSprite) || ((DisableableSprite)o).isEnabled())) {
                    return (Sprite)o;
                }
                ++ii;
            }
            return null;
        }
    }

    public static interface Obscurer {
        public Rectangle getObscured(boolean var1);
    }
}

