/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.geom;

import com.threerings.geom.Log;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class GeomUtil {
    public static int dot(Point v1s, Point v1e, Point v2s, Point v2e) {
        return (v1e.x - v1s.x) * (v2e.x - v2s.x) + (v1e.y - v1s.y) * (v2e.y - v2s.y);
    }

    public static int dot(int v1sx, int v1sy, int v1ex, int v1ey, int v2sx, int v2sy, int v2ex, int v2ey) {
        return (v1ex - v1sx) * (v2ex - v2sx) + (v1ey - v1sy) * (v2ey - v2sy);
    }

    public static int dot(Point vs, Point v1e, Point v2e) {
        return (v1e.x - vs.x) * (v2e.x - vs.x) + (v1e.y - vs.y) * (v2e.y - vs.y);
    }

    public static int dot(int vsx, int vsy, int v1ex, int v1ey, int v2ex, int v2ey) {
        return (v1ex - vsx) * (v2ex - vsx) + (v1ey - vsy) * (v2ey - vsy);
    }

    public static Point nearestToLine(Point p1, Point p2, Point p3, Point n) {
        int Ax = p2.x - p1.x;
        int Ay = p2.y - p1.y;
        float u = (p3.x - p1.x) * Ax + (p3.y - p1.y) * Ay;
        n.x = p1.x + Math.round((float)Ax * (u /= (float)(Ax * Ax + Ay * Ay)));
        n.y = p1.y + Math.round((float)Ay * u);
        return n;
    }

    public static boolean lineIntersection(Point2D p1, Point2D p2, boolean seg1, Point2D p3, Point2D p4, boolean seg2, Point2D result) {
        double ub;
        double y21;
        double x43;
        double x21;
        double y43 = p4.getY() - p3.getY();
        double denom = y43 * (x21 = p2.getX() - p1.getX()) - (x43 = p4.getX() - p3.getX()) * (y21 = p2.getY() - p1.getY());
        if (denom == 0.0) {
            return false;
        }
        double y13 = p1.getY() - p3.getY();
        double x13 = p1.getX() - p3.getX();
        double ua = (x43 * y13 - y43 * x13) / denom;
        if (seg1 && (ua < 0.0 || ua > 1.0)) {
            return false;
        }
        if (seg2 && ((ub = (x21 * y13 - y21 * x13) / denom) < 0.0 || ub > 1.0)) {
            return false;
        }
        double x = p1.getX() + ua * x21;
        double y = p1.getY() + ua * y21;
        result.setLocation(x, y);
        return true;
    }

    public static int whichSide(Point p1, double theta, Point p2) {
        int x = p1.x + (int)Math.round(1000.0 * Math.cos(theta += 1.5707963267948966));
        int y = p1.y + (int)Math.round(1000.0 * Math.sin(theta));
        return GeomUtil.dot(p1.x, p1.y, p2.x, p2.y, x, y);
    }

    public static void shiftToContain(Rectangle tainer, Rectangle tained) {
        if (tained.x < tainer.x) {
            tainer.x = tained.x;
        }
        if (tained.y < tainer.y) {
            tainer.y = tained.y;
        }
        if (tained.x + tained.width > tainer.x + tainer.width) {
            tainer.x = tained.x - (tainer.width - tained.width);
        }
        if (tained.y + tained.height > tainer.y + tainer.height) {
            tainer.y = tained.y - (tainer.height - tained.height);
        }
    }

    public static Rectangle grow(Rectangle source, Rectangle target) {
        if (target == null) {
            Log.log.warning((Object)("Can't grow with null rectangle [src=" + source + ", tgt=" + target + "]."), new Object[]{new Exception()});
        } else if (source == null) {
            source = new Rectangle(target);
        } else {
            source.add(target);
        }
        return source;
    }

    public static Rectangle getTile(int width, int height, int tileWidth, int tileHeight, int tileIndex) {
        Rectangle bounds = new Rectangle();
        GeomUtil.getTile(width, height, tileWidth, tileHeight, tileIndex, bounds);
        return bounds;
    }

    public static void getTile(int width, int height, int tileWidth, int tileHeight, int tileIndex, Rectangle bounds) {
        int tilesPerRow = width / tileWidth;
        if (tilesPerRow == 0) {
            bounds.setBounds(0, 0, width, height);
        } else {
            int row = tileIndex / tilesPerRow;
            int col = tileIndex % tilesPerRow;
            bounds.setBounds(tileWidth * col, tileHeight * row, tileWidth, tileHeight);
        }
    }
}

