/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.builder;

import com.samskivert.swing.VGroupLayout;
import com.threerings.cast.ComponentClass;
import com.threerings.cast.Log;
import com.threerings.cast.builder.BuilderModel;
import com.threerings.cast.builder.ClassEditor;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ComponentPanel
extends JPanel {
    public ComponentPanel(BuilderModel model, String cprefix) {
        this.setLayout((LayoutManager)new VGroupLayout(VGroupLayout.STRETCH));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addClassEditors(model, cprefix);
    }

    protected void addClassEditors(BuilderModel model, String cprefix) {
        List<ComponentClass> classes = model.getComponentClasses();
        int size = classes.size();
        int ii = 0;
        while (ii < size) {
            ComponentClass cclass = classes.get(ii);
            if (cclass.name.startsWith(cprefix)) {
                List<Integer> ccomps = model.getComponents(cclass);
                if (ccomps.size() > 0) {
                    this.add(new ClassEditor(model, cclass, ccomps));
                } else {
                    Log.log.info((Object)("Not creating editor for empty class [class=" + cclass + "]."), new Object[0]);
                }
            }
            ++ii;
        }
    }
}

