package com.threerings.resource.raz;

import java.io.IOException;
import java.io.InputStream;

class RazInputStream extends InputStream {

	private long length;
	RazSection section;
	private long readerOffset;
	
	RazInputStream(RazIndexEntry entry,RazBlock block) throws IOException {
		this.length = entry.fileSize;
		section = block.getFileSection(entry.blockIndex);
	}

	@Override
	public int read() throws IOException {
		if (readerOffset >= length) {
			return -1;
		}
		readerOffset++;
		return -1;//sectorReader.readInt8();
	}
	
	@Override
	public int read(byte[] b, int off, int len) throws IOException {
		if (b == null) {
			throw new NullPointerException();
		} else if (off < 0 || len < 0 || len > b.length - off) {
			throw new IndexOutOfBoundsException();
		} else if (len == 0) {
			return 0;
		}
		if (readerOffset >= length) {
			return -1;
		}
		if (len > length - readerOffset) {
			len = (int) (length - readerOffset);
		}
		int bytesRead = 0;
		/*while (bytesRead < len && readerOffset < length) {
			if (readerOffset / sectorSize == readerSector + 1) {
				prepareSector();
			}
			int bytesAvailable = sectorSize - (readerOffset % sectorSize);
			int remaining = len - bytesRead;
			int toRead = bytesAvailable < remaining ? bytesAvailable : remaining;
			toRead = sectorReader.readBlock(b, off + bytesRead, toRead);
			if (toRead == -1) {
				return bytesRead == 0 ? -1 : bytesRead;
			}
			readerOffset += toRead;
			bytesRead += toRead;
		}*/
		return bytesRead;
	}


	@Override
	public void close() throws IOException {
		super.close();
		
	}

}
