package com.threerings.resource.raz;

import java.io.IOException;
import java.io.RandomAccessFile;

public class RazIndexEntry {
	public int blockIndex;
	public int hashA;
	public int hashB;
	public int flags;
	public long fileSize;
	public long fileTime;
	public int crc32;
	
	public RazIndexEntry(RandomAccessFile accessFile) throws IOException{
		blockIndex = accessFile.readInt();
		hashA = accessFile.readInt();
		hashB = accessFile.readInt();
		flags = accessFile.readInt();
		fileSize = accessFile.readLong();
		fileTime = accessFile.readLong();
		crc32 = accessFile.readInt();
	}
	
	public int getFlags() {
		return flags;
	}

	public boolean isFile() {
		return (flags & 0x80000000) != 0;
	}

	public boolean isSingleUnit() {
		return (flags & 0x01000000) != 0;
	}

	public boolean isEncryptionAdjusted() {
		return (flags & 0x00020000) != 0;
	}

	public boolean isEncrypted() {
		return (flags & 0x00010000) != 0;
	}

	public boolean isCompressed() {
		return (flags & 0x00000200) != 0;
	}

	public boolean isImploded() {
		return (flags & 0x00000100) != 0;
	}
}
