package com.threerings.resource.raz;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class RazIndex {
	static final int[] cryptTable;
	static {
		cryptTable = new int[0xffff];
		int seed = 0x00100001;
		int index1;
		int index2;
		int i;
		for (index1 = 0; index1 < 0x100; index1++) {
			for (index2 = index1, i = 0; i < 5; i++, index2 += 0x100) {
				int temp1, temp2;
				seed = (seed * 125 + 3) % 0x2aaaab;
				temp1 = (seed & 0xffff) << 0x10;

				seed = (seed * 125 + 3) % 0x2aaaab;
				temp2 = (seed & 0xffff);

				cryptTable[index2] = temp1 | temp2;
			}
		}
	}
	
	
	private RazHeader header;
    
	RandomAccessFile fileAccess;
	private final boolean rw;
	private final File file;
    private Map<Hash, RazIndexEntry> entries;
    
    public RazIndex(File file) throws IOException {
		this(file, false);
	}

	public RazIndex(File file, boolean rw) throws IOException {
		this.file = file;
		this.rw = rw;
		openAndRead();
	}
	
	private void checkReadWrite() {
		if (!rw) {
			throw new IllegalStateException("read only");
		}
	}
	
	private void writeHeader() throws IOException {
		checkReadWrite();
		if (header == null) {
			header = new RazHeader(fileAccess);
		}
		header.wirte();
	}
	
	private void openAndRead() throws IOException {
		fileAccess = new RandomAccessFile(file, rw ? "rw" : "r");
		if (fileAccess.length() == 0) {
			if (header == null) {
				header = new RazHeader(fileAccess);
				header.wirte();
			}
		}
		header.read();
		readHashTable();
	}
	
	private void readHashTable() throws IOException{
		entries = new HashMap<Hash, RazIndexEntry>();
		fileAccess.seek(RazHeader.HEADER_SIZE);
		if (RazHeader.HEADER_SIZE >= fileAccess.length()) {
			return;
		}
		
		for(int i =0;i<header.entries; i++){
			if(fileAccess.getFilePointer() +1 >=  fileAccess.length()){
				return;
			}
			RazIndexEntry entry = new RazIndexEntry(fileAccess);
			Hash hash = new Hash(entry.hashA,entry.hashB);
			entries.put(hash, entry);
		}
	}
	
	static int hashString(String string, int hashType) {
		int seed1 = 0x7fed7fed;
		int seed2 = 0xeeeeeeee;

		string = string.toUpperCase();
		for (int i = 0; i < string.length(); i++) {
			int ch = string.charAt(i);
			seed1 = cryptTable[hashType * 0x100 + ch] ^ (seed1 + seed2);
			seed2 = ch + seed1 + seed2 + (seed2 << 5) + 3;
		}
		return seed1;
	}
	
	public static class Hash {
        private int code1;
        private int code2;

        Hash(int code1, int code2) {
            this.code1 = code1;
            this.code2 = code2;
        }

        Hash(String str) {
            this(hashString(str, 1), hashString(str, 2));
        }

        @Override
        public int hashCode() {
            return code2;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o instanceof Hash) {
                Hash that = (Hash) o;
                return this.code1 == that.code1 && this.code2 == that.code2;
            }
            return false;
        }
    }
}
