package com.threerings.resource.raz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RazBlock {
	public static int MAX_NUM_BLOCK = 3 * 1024 * 1024;
	public static int BLOCK_SIZE = 1024;
	public static int LEAF_SIZE = 8;
	
	RandomAccessFile fileAccess;
	private File file;
	private boolean rw;
	BitMap bitMap = null; 
	
	public RazBlock(File file,boolean rw) throws IOException{
		this.file = file;
		this.rw = rw;
		openAndRead();
	}

	private int getNextFreeBlock(){
		for(int i=bitMap.limitPos ;i <  MAX_NUM_BLOCK;i++){
			if(!bitMap.isSet(i)){
				return i;
			}
		}
		
		for(int i=0; i< bitMap.limitPos;i++){
			if(!bitMap.isSet(i)){
				return i;
			}
		}
		
		return -2;
	}
	
	private void openAndRead() throws IOException {
		fileAccess = new RandomAccessFile(file, rw ? "rw" : "r");
		if (fileAccess.length() == 0) {
			fileAccess.write(new byte[MAX_NUM_BLOCK/8]);
			bitMap = new BitMap(MAX_NUM_BLOCK);
		}else{
			int[] bit = new int[MAX_NUM_BLOCK];
			for(int i=0;i<MAX_NUM_BLOCK/32;i++){
				bit[i] = fileAccess.readInt();
			}
			bitMap =  new BitMap(bit);
		}
		
	}
	
	public synchronized void deleteFile(int index) throws IOException {
		int sectorSize = getSectorSize();
		while( index >= 0){
			bitMap.unset(index);
			fileAccess.seek(MAX_NUM_BLOCK/8+(sectorSize + LEAF_SIZE) * index);
			index = fileAccess.readInt();
		}
	}
	
	public RazSection getFileSection(int index) throws IOException{
		if(bitMap.isSet(index)){
			return null;
		}
		fileAccess.seek(getOffset(index));
		
		RazSection section = new RazSection(); 
		int next = fileAccess.readInt();
		int size = fileAccess.readInt();
		section.size = size;
		section.data = new byte[size];
		fileAccess.readFully(section.data);
		if(next >=0){
			section.next = getFileSection(next);
		}
		
		return section;
	}
	
	public long getOffset(int index){
		return MAX_NUM_BLOCK/8+(getSectorSize() + LEAF_SIZE) * index;
	}
	public synchronized int addFile(InputStream inputStream,long fileSize) throws IOException{
		int sectorSize = getSectorSize();
		byte[] data = new byte[sectorSize];
		//seek next free block
		int frist,index;
		frist = index = getNextFreeBlock();
		for (int i = 0; i < (fileSize + sectorSize - 1) / sectorSize; i++) {
			long remaining = fileSize - i * sectorSize;
			int datalen = inputStream.read(data);
			
			//write block flag
			bitMap.set(index);
			
			//seek position
			fileAccess.seek(getOffset(index));
			
			if(datalen <= sectorSize && remaining <= 0){
				fileAccess.writeInt(-1);
				fileAccess.writeInt(datalen);
			}else{
				index = getNextFreeBlock();
				fileAccess.writeInt(index);
				fileAccess.writeInt(datalen);
			}
			fileAccess.write(data, 0, datalen); 
		}
		
		return frist;
	}

	private int getSectorSize() {
		return 1024;
	}
	
}
