/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.threerings.miso.client.TileOp;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import java.awt.Point;
import java.awt.Rectangle;

public class TileOpApplicator {
    protected MisoSceneMetrics _metrics;
    protected Rectangle _tbounds;

    public TileOpApplicator(MisoSceneMetrics metrics) {
        this._metrics = metrics;
        this._tbounds = new Rectangle(0, 0, this._metrics.tilewid, this._metrics.tilehei);
    }

    public void applyToTiles(Rectangle region, TileOp op) {
        int dy;
        int dx;
        boolean top;
        Point tpos = MisoUtil.screenToTile(this._metrics, region.x, region.y, new Point());
        Point spos = MisoUtil.tileToScreen(this._metrics, tpos.x, tpos.y, new Point());
        boolean left = region.x - spos.x < this._metrics.tilehwid;
        boolean bl = top = region.y - spos.y < this._metrics.tilehhei;
        if (left) {
            dx = 0;
            dy = 1;
        } else {
            dx = 1;
            dy = 0;
        }
        if (top) {
            if (left) {
                --tpos.x;
            } else {
                --tpos.y;
            }
            dx = 1 - dx;
            dy = 1 - dy;
        }
        int rightx = region.x + region.width;
        int bottomy = region.y + region.height;
        MisoUtil.tileToScreen(this._metrics, tpos.x, tpos.y, spos);
        while (spos.y < bottomy) {
            int tx = tpos.x;
            int ty = tpos.y;
            this._tbounds.x = spos.x;
            this._tbounds.y = spos.y;
            while (this._tbounds.x < rightx) {
                op.apply(tx, ty, this._tbounds);
                ++tx;
                --ty;
                this._tbounds.x += this._metrics.tilewid;
            }
            tpos.x += dx;
            dx = 1 - dx;
            tpos.y += dy;
            dy = 1 - dy;
            MisoUtil.tileToScreen(this._metrics, tpos.x, tpos.y, spos);
        }
    }
}

