/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.google.common.collect.Lists;
import com.samskivert.util.ObserverList;
import com.samskivert.util.SortableArrayList;
import com.samskivert.util.Tuple;
import com.threerings.media.AbstractMedia;
import com.threerings.media.Log;
import com.threerings.media.MediaConstants;
import com.threerings.media.MediaHost;
import com.threerings.media.RegionManager;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractMediaManager
implements MediaConstants {
    protected static final Comparator<AbstractMedia> RENDER_ORDER = new Comparator<AbstractMedia>(){

        @Override
        public int compare(AbstractMedia am1, AbstractMedia am2) {
            return am1.renderCompareTo(am2);
        }
    };
    protected MediaHost _host;
    protected RegionManager _remgr;
    protected List<Tuple<ObserverList<Object>, ObserverList.ObserverOp<Object>>> _notify = Lists.newArrayList();
    protected SortableArrayList<AbstractMedia> _media = this.createMediaList();
    protected int _tickpos = -1;
    protected long _tickStamp;

    public void init(MediaHost host, RegionManager remgr) {
        this._host = host;
        this._remgr = remgr;
    }

    public RegionManager getRegionManager() {
        return this._remgr;
    }

    public Graphics2D createGraphics() {
        return this._host.createGraphics();
    }

    public void tick(long tickStamp) {
        this._tickStamp = tickStamp;
        this.tickAllMedia(tickStamp);
        this.dispatchNotifications();
    }

    public void willPaint() {
        this._tickStamp = 0L;
    }

    public void paint(Graphics2D gfx, int layer, Shape clip) {
        int ii = 0;
        int nn = this._media.size();
        while (ii < nn) {
            AbstractMedia media = (AbstractMedia)this._media.get(ii);
            int order = media.getRenderOrder();
            try {
                if ((layer == 3 || layer == 2 && order >= 0 || layer == 1 && order < 0) && clip.intersects(media.getBounds())) {
                    media.paint(gfx);
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to render media", new Object[]{"media", media, e});
            }
            ++ii;
        }
    }

    public void fastForward(long timeDelta) {
        if (this._tickStamp > 0L) {
            Log.log.warning((Object)"Egads! Asked to fastForward() during a tick.", new Object[]{new Exception()});
        }
        int ii = 0;
        int nn = this._media.size();
        while (ii < nn) {
            ((AbstractMedia)this._media.get(ii)).fastForward(timeDelta);
            ++ii;
        }
    }

    public boolean isManaged(AbstractMedia media) {
        return this._media.contains((Object)media);
    }

    public void viewLocationDidChange(int dx, int dy) {
        int ii = 0;
        int ll = this._media.size();
        while (ii < ll) {
            ((AbstractMedia)this._media.get(ii)).viewLocationDidChange(dx, dy);
            ++ii;
        }
    }

    public void renderOrderDidChange(AbstractMedia media) {
        if (this._tickStamp > 0L) {
            Log.log.warning((Object)"Egads! Render order changed during a tick.", new Object[]{new Exception()});
        }
        this._media.remove((Object)media);
        this._media.insertSorted((Object)media, RENDER_ORDER);
    }

    protected void tickAllMedia(long tickStamp) {
        this._tickpos = 0;
        while (this._tickpos < this._media.size()) {
            this.tickMedia((AbstractMedia)this._media.get(this._tickpos), tickStamp);
            ++this._tickpos;
        }
        this._tickpos = -1;
    }

    protected boolean insertMedia(AbstractMedia media) {
        if (this._media.contains((Object)media)) {
            Log.log.warning((Object)("Attempt to insert media more than once [media=" + media + "]."), new Object[]{new Exception()});
            return false;
        }
        media.init(this);
        int ipos = this._media.insertSorted((Object)media, RENDER_ORDER);
        if (this._tickStamp > 0L) {
            if (this._tickpos == -1) {
                this.tickMedia(media, this._tickStamp);
            } else if (ipos <= this._tickpos) {
                ++this._tickpos;
                this.tickMedia(media, this._tickStamp);
            }
        }
        return true;
    }

    protected final void tickMedia(AbstractMedia media, long tickStamp) {
        if (media._firstTick == 0L) {
            media.willStart(tickStamp);
        }
        media.tick(tickStamp);
    }

    protected boolean removeMedia(AbstractMedia media) {
        int mpos = this._media.indexOf((Object)media);
        if (mpos != -1) {
            this._media.remove(mpos);
            media.invalidate();
            media.shutdown();
            if (mpos <= this._tickpos) {
                --this._tickpos;
            }
            return true;
        }
        Log.log.warning((Object)("Attempt to remove media that wasn't inserted [media=" + media + "]."), new Object[0]);
        return false;
    }

    protected void clearMedia() {
        if (this._tickStamp > 0L) {
            Log.log.warning((Object)"Egads! Requested to clearMedia() during a tick.", new Object[]{new Exception()});
        }
        int ii = this._media.size() - 1;
        while (ii >= 0) {
            ((AbstractMedia)this._media.remove(ii)).shutdown();
            --ii;
        }
    }

    public void queueNotification(ObserverList<Object> observers, ObserverList.ObserverOp<Object> event) {
        this._notify.add((Tuple<ObserverList<Object>, ObserverList.ObserverOp<Object>>)new Tuple(observers, event));
    }

    protected abstract SortableArrayList<? extends AbstractMedia> createMediaList();

    protected void dispatchNotifications() {
        int ii = 0;
        int nn = this._notify.size();
        while (ii < nn) {
            Tuple<ObserverList<Object>, ObserverList.ObserverOp<Object>> tuple = this._notify.get(ii);
            ((ObserverList)tuple.left).apply((ObserverList.ObserverOp)tuple.right);
            ++ii;
        }
        this._notify.clear();
    }
}

