/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.samskivert.util.RandomUtil;
import com.threerings.cast.CharacterDescriptor;
import com.threerings.cast.ComponentClass;
import com.threerings.cast.ComponentRepository;
import com.threerings.cast.Log;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.Colorization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CastUtil {
    public static CharacterDescriptor getRandomDescriptor(ComponentRepository crepo, String gender, String[] COMP_CLASSES, ColorPository cpos, String[] COLOR_CLASSES) {
        ArrayList classes = Lists.newArrayList();
        String[] stringArray = COMP_CLASSES;
        int n = COMP_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String cname = String.valueOf(gender) + "/" + element;
            ComponentClass cclass = crepo.getComponentClass(cname);
            if (cclass == null) {
                Log.log.warning((Object)"Missing definition for component class", new Object[]{"class", cname});
            } else {
                Iterator<Integer> iter = crepo.enumerateComponentIds(cclass);
                if (!iter.hasNext()) {
                    Log.log.info((Object)"Skipping class for which we have no components", new Object[]{"class", cclass});
                } else {
                    classes.add(cclass);
                }
            }
            ++n2;
        }
        int[] components = new int[classes.size()];
        Colorization[][] zations = new Colorization[components.length][];
        int ii = 0;
        while (ii < components.length) {
            ComponentClass cclass = (ComponentClass)classes.get(ii);
            ArrayList choices = Lists.newArrayList();
            Iterators.addAll((Collection)choices, crepo.enumerateComponentIds(cclass));
            zations[ii] = new Colorization[COLOR_CLASSES.length];
            int zz = 0;
            while (zz < COLOR_CLASSES.length) {
                zations[ii][zz] = cpos.getRandomStartingColor(COLOR_CLASSES[zz]).getColorization();
                ++zz;
            }
            if (choices.size() > 0) {
                int idx = RandomUtil.getInt((int)choices.size());
                components[ii] = (Integer)choices.get(idx);
            } else {
                Log.log.info((Object)"Have no components in class", new Object[]{"class", cclass});
            }
            ++ii;
        }
        return new CharacterDescriptor(components, zations);
    }
}

