/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.google.common.collect.Lists;
import com.threerings.media.Log;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionManager {
    protected List<Rectangle> _dirty = Lists.newArrayList();

    public void invalidateRegion(int x, int y, int width, int height) {
        if (this.isValidSize(width, height)) {
            this.addDirtyRegion(new Rectangle(x, y, width, height));
        }
    }

    public void invalidateRegion(Rectangle rect) {
        if (this.isValidSize(rect.width, rect.height)) {
            this.addDirtyRegion((Rectangle)rect.clone());
        }
    }

    public void addDirtyRegion(Rectangle rect) {
        if (!EventQueue.isDispatchThread()) {
            Log.log.warning((Object)"Oi! Region dirtied on non-AWT thread", new Object[]{"rect", rect, new Exception()});
        }
        if (rect == null) {
            Log.log.warning((Object)"Attempt to dirty a null rect!?", new Object[]{new Exception()});
            return;
        }
        long x = rect.x;
        long y = rect.y;
        if (Math.abs(x) > 0x3FFFFFFFL || Math.abs(y) > 0x3FFFFFFFL) {
            Log.log.warning((Object)"Requested to dirty questionable region", new Object[]{"rect", rect, new Exception()});
            return;
        }
        if (this.isValidSize(rect.width, rect.height)) {
            this._dirty.add(rect);
        }
    }

    protected final boolean isValidSize(int width, int height) {
        if (width < 0 || height < 0) {
            Log.log.warning((Object)"Attempt to add invalid dirty region?!", new Object[]{"size", width + "x" + height, new Exception()});
            return false;
        }
        return width != 0 && height != 0;
    }

    public boolean haveDirtyRegions() {
        return this._dirty.size() > 0;
    }

    public List<Rectangle> peekDirtyRegions() {
        return this._dirty;
    }

    public Rectangle[] getDirtyRegions() {
        ArrayList merged = Lists.newArrayList();
        for (int ii = this._dirty.size() - 1; ii >= 0; --ii) {
            Rectangle mr = this._dirty.remove(ii);
            for (int jj = ii - 1; jj >= 0; --jj) {
                Rectangle r = this._dirty.get(jj);
                if (!mr.intersects(r)) continue;
                this._dirty.remove(jj);
                --ii;
                mr.add(r);
            }
            merged.add(mr);
        }
        return merged.toArray(new Rectangle[merged.size()]);
    }
}

